package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{ServerId, NextToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListAccessesResponse(
    nextToken: Option[NextToken] = None,
    serverId: ServerId,
    accesses: Iterable[zio.aws.transfer.model.ListedAccess]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.ListAccessesResponse = {
    import ListAccessesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.ListAccessesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .serverId(ServerId.unwrap(serverId): java.lang.String)
      .accesses(accesses.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.ListAccessesResponse.ReadOnly =
    zio.aws.transfer.model.ListAccessesResponse.wrap(buildAwsValue())
}
object ListAccessesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.ListAccessesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.ListAccessesResponse =
      zio.aws.transfer.model.ListAccessesResponse(
        nextToken.map(value => value),
        serverId,
        accesses.map { item =>
          item.asEditable
        }
      )
    def nextToken: Option[NextToken]
    def serverId: ServerId
    def accesses: List[zio.aws.transfer.model.ListedAccess.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getServerId: ZIO[Any, Nothing, ServerId] = ZIO.succeed(serverId)
    def getAccesses: ZIO[Any, Nothing, List[
      zio.aws.transfer.model.ListedAccess.ReadOnly
    ]] = ZIO.succeed(accesses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.ListAccessesResponse
  ) extends zio.aws.transfer.model.ListAccessesResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.transfer.model.primitives.NextToken(value))
    override val serverId: ServerId =
      zio.aws.transfer.model.primitives.ServerId(impl.serverId())
    override val accesses: List[zio.aws.transfer.model.ListedAccess.ReadOnly] =
      impl
        .accesses()
        .asScala
        .map { item =>
          zio.aws.transfer.model.ListedAccess.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.ListAccessesResponse
  ): zio.aws.transfer.model.ListAccessesResponse.ReadOnly = new Wrapper(impl)
}
