package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{WorkflowId, NextToken, MaxResults}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListExecutionsRequest(
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None,
    workflowId: WorkflowId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.ListExecutionsRequest = {
    import ListExecutionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.ListExecutionsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .workflowId(WorkflowId.unwrap(workflowId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.ListExecutionsRequest.ReadOnly =
    zio.aws.transfer.model.ListExecutionsRequest.wrap(buildAwsValue())
}
object ListExecutionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.ListExecutionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.ListExecutionsRequest =
      zio.aws.transfer.model.ListExecutionsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        workflowId
      )
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def workflowId: WorkflowId
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getWorkflowId: ZIO[Any, Nothing, WorkflowId] = ZIO.succeed(workflowId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.ListExecutionsRequest
  ) extends zio.aws.transfer.model.ListExecutionsRequest.ReadOnly {
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.transfer.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.transfer.model.primitives.NextToken(value))
    override val workflowId: WorkflowId =
      zio.aws.transfer.model.primitives.WorkflowId(impl.workflowId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.ListExecutionsRequest
  ): zio.aws.transfer.model.ListExecutionsRequest.ReadOnly = new Wrapper(impl)
}
