package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{NextToken, MaxResults, Arn}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(
    arn: Arn,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.ListTagsForResourceRequest
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.transfer.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.ListTagsForResourceRequest =
      zio.aws.transfer.model.ListTagsForResourceRequest(
        arn,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def arn: Arn
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.ListTagsForResourceRequest
  ) extends zio.aws.transfer.model.ListTagsForResourceRequest.ReadOnly {
    override val arn: Arn = zio.aws.transfer.model.primitives.Arn(impl.arn())
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.transfer.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.transfer.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.ListTagsForResourceRequest
  ): zio.aws.transfer.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
