package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{ServerId, NextToken, MaxResults}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListUsersRequest(
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None,
    serverId: ServerId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.ListUsersRequest = {
    import ListUsersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.ListUsersRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .serverId(ServerId.unwrap(serverId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.ListUsersRequest.ReadOnly =
    zio.aws.transfer.model.ListUsersRequest.wrap(buildAwsValue())
}
object ListUsersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.ListUsersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.ListUsersRequest =
      zio.aws.transfer.model.ListUsersRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        serverId
      )
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def serverId: ServerId
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getServerId: ZIO[Any, Nothing, ServerId] = ZIO.succeed(serverId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.ListUsersRequest
  ) extends zio.aws.transfer.model.ListUsersRequest.ReadOnly {
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.transfer.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.transfer.model.primitives.NextToken(value))
    override val serverId: ServerId =
      zio.aws.transfer.model.primitives.ServerId(impl.serverId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.ListUsersRequest
  ): zio.aws.transfer.model.ListUsersRequest.ReadOnly = new Wrapper(impl)
}
