package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{ServerId, NextToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListUsersResponse(
    nextToken: Option[NextToken] = None,
    serverId: ServerId,
    users: Iterable[zio.aws.transfer.model.ListedUser]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.ListUsersResponse = {
    import ListUsersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.ListUsersResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .serverId(ServerId.unwrap(serverId): java.lang.String)
      .users(users.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.ListUsersResponse.ReadOnly =
    zio.aws.transfer.model.ListUsersResponse.wrap(buildAwsValue())
}
object ListUsersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.ListUsersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.ListUsersResponse =
      zio.aws.transfer.model.ListUsersResponse(
        nextToken.map(value => value),
        serverId,
        users.map { item =>
          item.asEditable
        }
      )
    def nextToken: Option[NextToken]
    def serverId: ServerId
    def users: List[zio.aws.transfer.model.ListedUser.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getServerId: ZIO[Any, Nothing, ServerId] = ZIO.succeed(serverId)
    def getUsers
        : ZIO[Any, Nothing, List[zio.aws.transfer.model.ListedUser.ReadOnly]] =
      ZIO.succeed(users)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.ListUsersResponse
  ) extends zio.aws.transfer.model.ListUsersResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.transfer.model.primitives.NextToken(value))
    override val serverId: ServerId =
      zio.aws.transfer.model.primitives.ServerId(impl.serverId())
    override val users: List[zio.aws.transfer.model.ListedUser.ReadOnly] = impl
      .users()
      .asScala
      .map { item =>
        zio.aws.transfer.model.ListedUser.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.ListUsersResponse
  ): zio.aws.transfer.model.ListUsersResponse.ReadOnly = new Wrapper(impl)
}
