package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{ExternalId, Role, HomeDirectory}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListedAccess(
    homeDirectory: Option[HomeDirectory] = None,
    homeDirectoryType: Option[zio.aws.transfer.model.HomeDirectoryType] = None,
    role: Option[Role] = None,
    externalId: Option[ExternalId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.ListedAccess = {
    import ListedAccess.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.ListedAccess
      .builder()
      .optionallyWith(
        homeDirectory.map(value =>
          HomeDirectory.unwrap(value): java.lang.String
        )
      )(_.homeDirectory)
      .optionallyWith(homeDirectoryType.map(value => value.unwrap))(
        _.homeDirectoryType
      )
      .optionallyWith(role.map(value => Role.unwrap(value): java.lang.String))(
        _.role
      )
      .optionallyWith(
        externalId.map(value => ExternalId.unwrap(value): java.lang.String)
      )(_.externalId)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.ListedAccess.ReadOnly =
    zio.aws.transfer.model.ListedAccess.wrap(buildAwsValue())
}
object ListedAccess {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.ListedAccess
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.ListedAccess =
      zio.aws.transfer.model.ListedAccess(
        homeDirectory.map(value => value),
        homeDirectoryType.map(value => value),
        role.map(value => value),
        externalId.map(value => value)
      )
    def homeDirectory: Option[HomeDirectory]
    def homeDirectoryType: Option[zio.aws.transfer.model.HomeDirectoryType]
    def role: Option[Role]
    def externalId: Option[ExternalId]
    def getHomeDirectory: ZIO[Any, AwsError, HomeDirectory] =
      AwsError.unwrapOptionField("homeDirectory", homeDirectory)
    def getHomeDirectoryType
        : ZIO[Any, AwsError, zio.aws.transfer.model.HomeDirectoryType] =
      AwsError.unwrapOptionField("homeDirectoryType", homeDirectoryType)
    def getRole: ZIO[Any, AwsError, Role] =
      AwsError.unwrapOptionField("role", role)
    def getExternalId: ZIO[Any, AwsError, ExternalId] =
      AwsError.unwrapOptionField("externalId", externalId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.ListedAccess
  ) extends zio.aws.transfer.model.ListedAccess.ReadOnly {
    override val homeDirectory: Option[HomeDirectory] = scala
      .Option(impl.homeDirectory())
      .map(value => zio.aws.transfer.model.primitives.HomeDirectory(value))
    override val homeDirectoryType
        : Option[zio.aws.transfer.model.HomeDirectoryType] = scala
      .Option(impl.homeDirectoryType())
      .map(value => zio.aws.transfer.model.HomeDirectoryType.wrap(value))
    override val role: Option[Role] = scala
      .Option(impl.role())
      .map(value => zio.aws.transfer.model.primitives.Role(value))
    override val externalId: Option[ExternalId] = scala
      .Option(impl.externalId())
      .map(value => zio.aws.transfer.model.primitives.ExternalId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.ListedAccess
  ): zio.aws.transfer.model.ListedAccess.ReadOnly = new Wrapper(impl)
}
