package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.ExecutionId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListedExecution(
    executionId: Option[ExecutionId] = None,
    initialFileLocation: Option[zio.aws.transfer.model.FileLocation] = None,
    serviceMetadata: Option[zio.aws.transfer.model.ServiceMetadata] = None,
    status: Option[zio.aws.transfer.model.ExecutionStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.ListedExecution = {
    import ListedExecution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.ListedExecution
      .builder()
      .optionallyWith(
        executionId.map(value => ExecutionId.unwrap(value): java.lang.String)
      )(_.executionId)
      .optionallyWith(initialFileLocation.map(value => value.buildAwsValue()))(
        _.initialFileLocation
      )
      .optionallyWith(serviceMetadata.map(value => value.buildAwsValue()))(
        _.serviceMetadata
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.ListedExecution.ReadOnly =
    zio.aws.transfer.model.ListedExecution.wrap(buildAwsValue())
}
object ListedExecution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.ListedExecution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.ListedExecution =
      zio.aws.transfer.model.ListedExecution(
        executionId.map(value => value),
        initialFileLocation.map(value => value.asEditable),
        serviceMetadata.map(value => value.asEditable),
        status.map(value => value)
      )
    def executionId: Option[ExecutionId]
    def initialFileLocation
        : Option[zio.aws.transfer.model.FileLocation.ReadOnly]
    def serviceMetadata: Option[zio.aws.transfer.model.ServiceMetadata.ReadOnly]
    def status: Option[zio.aws.transfer.model.ExecutionStatus]
    def getExecutionId: ZIO[Any, AwsError, ExecutionId] =
      AwsError.unwrapOptionField("executionId", executionId)
    def getInitialFileLocation
        : ZIO[Any, AwsError, zio.aws.transfer.model.FileLocation.ReadOnly] =
      AwsError.unwrapOptionField("initialFileLocation", initialFileLocation)
    def getServiceMetadata
        : ZIO[Any, AwsError, zio.aws.transfer.model.ServiceMetadata.ReadOnly] =
      AwsError.unwrapOptionField("serviceMetadata", serviceMetadata)
    def getStatus: ZIO[Any, AwsError, zio.aws.transfer.model.ExecutionStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.ListedExecution
  ) extends zio.aws.transfer.model.ListedExecution.ReadOnly {
    override val executionId: Option[ExecutionId] = scala
      .Option(impl.executionId())
      .map(value => zio.aws.transfer.model.primitives.ExecutionId(value))
    override val initialFileLocation
        : Option[zio.aws.transfer.model.FileLocation.ReadOnly] = scala
      .Option(impl.initialFileLocation())
      .map(value => zio.aws.transfer.model.FileLocation.wrap(value))
    override val serviceMetadata
        : Option[zio.aws.transfer.model.ServiceMetadata.ReadOnly] = scala
      .Option(impl.serviceMetadata())
      .map(value => zio.aws.transfer.model.ServiceMetadata.wrap(value))
    override val status: Option[zio.aws.transfer.model.ExecutionStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.transfer.model.ExecutionStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.ListedExecution
  ): zio.aws.transfer.model.ListedExecution.ReadOnly = new Wrapper(impl)
}
