package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{UserCount, ServerId, Role, Arn}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListedServer(
    arn: Arn,
    domain: Option[zio.aws.transfer.model.Domain] = None,
    identityProviderType: Option[zio.aws.transfer.model.IdentityProviderType] =
      None,
    endpointType: Option[zio.aws.transfer.model.EndpointType] = None,
    loggingRole: Option[Role] = None,
    serverId: Option[ServerId] = None,
    state: Option[zio.aws.transfer.model.State] = None,
    userCount: Option[UserCount] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.ListedServer = {
    import ListedServer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.ListedServer
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .optionallyWith(domain.map(value => value.unwrap))(_.domain)
      .optionallyWith(identityProviderType.map(value => value.unwrap))(
        _.identityProviderType
      )
      .optionallyWith(endpointType.map(value => value.unwrap))(_.endpointType)
      .optionallyWith(
        loggingRole.map(value => Role.unwrap(value): java.lang.String)
      )(_.loggingRole)
      .optionallyWith(
        serverId.map(value => ServerId.unwrap(value): java.lang.String)
      )(_.serverId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(userCount.map(value => UserCount.unwrap(value): Integer))(
        _.userCount
      )
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.ListedServer.ReadOnly =
    zio.aws.transfer.model.ListedServer.wrap(buildAwsValue())
}
object ListedServer {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.ListedServer
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.ListedServer =
      zio.aws.transfer.model.ListedServer(
        arn,
        domain.map(value => value),
        identityProviderType.map(value => value),
        endpointType.map(value => value),
        loggingRole.map(value => value),
        serverId.map(value => value),
        state.map(value => value),
        userCount.map(value => value)
      )
    def arn: Arn
    def domain: Option[zio.aws.transfer.model.Domain]
    def identityProviderType
        : Option[zio.aws.transfer.model.IdentityProviderType]
    def endpointType: Option[zio.aws.transfer.model.EndpointType]
    def loggingRole: Option[Role]
    def serverId: Option[ServerId]
    def state: Option[zio.aws.transfer.model.State]
    def userCount: Option[UserCount]
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getDomain: ZIO[Any, AwsError, zio.aws.transfer.model.Domain] =
      AwsError.unwrapOptionField("domain", domain)
    def getIdentityProviderType
        : ZIO[Any, AwsError, zio.aws.transfer.model.IdentityProviderType] =
      AwsError.unwrapOptionField("identityProviderType", identityProviderType)
    def getEndpointType
        : ZIO[Any, AwsError, zio.aws.transfer.model.EndpointType] =
      AwsError.unwrapOptionField("endpointType", endpointType)
    def getLoggingRole: ZIO[Any, AwsError, Role] =
      AwsError.unwrapOptionField("loggingRole", loggingRole)
    def getServerId: ZIO[Any, AwsError, ServerId] =
      AwsError.unwrapOptionField("serverId", serverId)
    def getState: ZIO[Any, AwsError, zio.aws.transfer.model.State] =
      AwsError.unwrapOptionField("state", state)
    def getUserCount: ZIO[Any, AwsError, UserCount] =
      AwsError.unwrapOptionField("userCount", userCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.ListedServer
  ) extends zio.aws.transfer.model.ListedServer.ReadOnly {
    override val arn: Arn = zio.aws.transfer.model.primitives.Arn(impl.arn())
    override val domain: Option[zio.aws.transfer.model.Domain] = scala
      .Option(impl.domain())
      .map(value => zio.aws.transfer.model.Domain.wrap(value))
    override val identityProviderType
        : Option[zio.aws.transfer.model.IdentityProviderType] = scala
      .Option(impl.identityProviderType())
      .map(value => zio.aws.transfer.model.IdentityProviderType.wrap(value))
    override val endpointType: Option[zio.aws.transfer.model.EndpointType] =
      scala
        .Option(impl.endpointType())
        .map(value => zio.aws.transfer.model.EndpointType.wrap(value))
    override val loggingRole: Option[Role] = scala
      .Option(impl.loggingRole())
      .map(value => zio.aws.transfer.model.primitives.Role(value))
    override val serverId: Option[ServerId] = scala
      .Option(impl.serverId())
      .map(value => zio.aws.transfer.model.primitives.ServerId(value))
    override val state: Option[zio.aws.transfer.model.State] = scala
      .Option(impl.state())
      .map(value => zio.aws.transfer.model.State.wrap(value))
    override val userCount: Option[UserCount] = scala
      .Option(impl.userCount())
      .map(value => zio.aws.transfer.model.primitives.UserCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.ListedServer
  ): zio.aws.transfer.model.ListedServer.ReadOnly = new Wrapper(impl)
}
