package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{LogGroupName, Role}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LoggingConfiguration(
    loggingRole: Option[Role] = None,
    logGroupName: Option[LogGroupName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.LoggingConfiguration = {
    import LoggingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.LoggingConfiguration
      .builder()
      .optionallyWith(
        loggingRole.map(value => Role.unwrap(value): java.lang.String)
      )(_.loggingRole)
      .optionallyWith(
        logGroupName.map(value => LogGroupName.unwrap(value): java.lang.String)
      )(_.logGroupName)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.LoggingConfiguration.ReadOnly =
    zio.aws.transfer.model.LoggingConfiguration.wrap(buildAwsValue())
}
object LoggingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.LoggingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.LoggingConfiguration =
      zio.aws.transfer.model.LoggingConfiguration(
        loggingRole.map(value => value),
        logGroupName.map(value => value)
      )
    def loggingRole: Option[Role]
    def logGroupName: Option[LogGroupName]
    def getLoggingRole: ZIO[Any, AwsError, Role] =
      AwsError.unwrapOptionField("loggingRole", loggingRole)
    def getLogGroupName: ZIO[Any, AwsError, LogGroupName] =
      AwsError.unwrapOptionField("logGroupName", logGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.LoggingConfiguration
  ) extends zio.aws.transfer.model.LoggingConfiguration.ReadOnly {
    override val loggingRole: Option[Role] = scala
      .Option(impl.loggingRole())
      .map(value => zio.aws.transfer.model.primitives.Role(value))
    override val logGroupName: Option[LogGroupName] = scala
      .Option(impl.logGroupName())
      .map(value => zio.aws.transfer.model.primitives.LogGroupName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.LoggingConfiguration
  ): zio.aws.transfer.model.LoggingConfiguration.ReadOnly = new Wrapper(impl)
}
