package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{S3Etag, S3VersionId, S3Key, S3Bucket}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class S3FileLocation(
    bucket: Option[S3Bucket] = None,
    key: Option[S3Key] = None,
    versionId: Option[S3VersionId] = None,
    etag: Option[S3Etag] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.S3FileLocation = {
    import S3FileLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.S3FileLocation
      .builder()
      .optionallyWith(
        bucket.map(value => S3Bucket.unwrap(value): java.lang.String)
      )(_.bucket)
      .optionallyWith(key.map(value => S3Key.unwrap(value): java.lang.String))(
        _.key
      )
      .optionallyWith(
        versionId.map(value => S3VersionId.unwrap(value): java.lang.String)
      )(_.versionId)
      .optionallyWith(
        etag.map(value => S3Etag.unwrap(value): java.lang.String)
      )(_.etag)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.S3FileLocation.ReadOnly =
    zio.aws.transfer.model.S3FileLocation.wrap(buildAwsValue())
}
object S3FileLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.S3FileLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.S3FileLocation =
      zio.aws.transfer.model.S3FileLocation(
        bucket.map(value => value),
        key.map(value => value),
        versionId.map(value => value),
        etag.map(value => value)
      )
    def bucket: Option[S3Bucket]
    def key: Option[S3Key]
    def versionId: Option[S3VersionId]
    def etag: Option[S3Etag]
    def getBucket: ZIO[Any, AwsError, S3Bucket] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getKey: ZIO[Any, AwsError, S3Key] =
      AwsError.unwrapOptionField("key", key)
    def getVersionId: ZIO[Any, AwsError, S3VersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getEtag: ZIO[Any, AwsError, S3Etag] =
      AwsError.unwrapOptionField("etag", etag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.S3FileLocation
  ) extends zio.aws.transfer.model.S3FileLocation.ReadOnly {
    override val bucket: Option[S3Bucket] = scala
      .Option(impl.bucket())
      .map(value => zio.aws.transfer.model.primitives.S3Bucket(value))
    override val key: Option[S3Key] = scala
      .Option(impl.key())
      .map(value => zio.aws.transfer.model.primitives.S3Key(value))
    override val versionId: Option[S3VersionId] = scala
      .Option(impl.versionId())
      .map(value => zio.aws.transfer.model.primitives.S3VersionId(value))
    override val etag: Option[S3Etag] = scala
      .Option(impl.etag())
      .map(value => zio.aws.transfer.model.primitives.S3Etag(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.S3FileLocation
  ): zio.aws.transfer.model.S3FileLocation.ReadOnly = new Wrapper(impl)
}
