package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{SourceFileLocation, WorkflowStepName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TagStepDetails(
    name: Option[WorkflowStepName] = None,
    tags: Option[Iterable[zio.aws.transfer.model.S3Tag]] = None,
    sourceFileLocation: Option[SourceFileLocation] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.TagStepDetails = {
    import TagStepDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.TagStepDetails
      .builder()
      .optionallyWith(
        name.map(value => WorkflowStepName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        sourceFileLocation.map(value =>
          SourceFileLocation.unwrap(value): java.lang.String
        )
      )(_.sourceFileLocation)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.TagStepDetails.ReadOnly =
    zio.aws.transfer.model.TagStepDetails.wrap(buildAwsValue())
}
object TagStepDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.TagStepDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.TagStepDetails =
      zio.aws.transfer.model.TagStepDetails(
        name.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sourceFileLocation.map(value => value)
      )
    def name: Option[WorkflowStepName]
    def tags: Option[List[zio.aws.transfer.model.S3Tag.ReadOnly]]
    def sourceFileLocation: Option[SourceFileLocation]
    def getName: ZIO[Any, AwsError, WorkflowStepName] =
      AwsError.unwrapOptionField("name", name)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.transfer.model.S3Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getSourceFileLocation: ZIO[Any, AwsError, SourceFileLocation] =
      AwsError.unwrapOptionField("sourceFileLocation", sourceFileLocation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.TagStepDetails
  ) extends zio.aws.transfer.model.TagStepDetails.ReadOnly {
    override val name: Option[WorkflowStepName] = scala
      .Option(impl.name())
      .map(value => zio.aws.transfer.model.primitives.WorkflowStepName(value))
    override val tags: Option[List[zio.aws.transfer.model.S3Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transfer.model.S3Tag.wrap(item)
          }.toList
        )
    override val sourceFileLocation: Option[SourceFileLocation] = scala
      .Option(impl.sourceFileLocation())
      .map(value => zio.aws.transfer.model.primitives.SourceFileLocation(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.TagStepDetails
  ): zio.aws.transfer.model.TagStepDetails.ReadOnly = new Wrapper(impl)
}
