package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{Url, Message, StatusCode, Response}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TestIdentityProviderResponse(
    response: Option[Response] = None,
    statusCode: StatusCode,
    message: Option[Message] = None,
    url: Url
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.TestIdentityProviderResponse = {
    import TestIdentityProviderResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.TestIdentityProviderResponse
      .builder()
      .optionallyWith(
        response.map(value => Response.unwrap(value): java.lang.String)
      )(_.response)
      .statusCode(StatusCode.unwrap(statusCode): Integer)
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .url(Url.unwrap(url): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.TestIdentityProviderResponse.ReadOnly =
    zio.aws.transfer.model.TestIdentityProviderResponse.wrap(buildAwsValue())
}
object TestIdentityProviderResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.TestIdentityProviderResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.TestIdentityProviderResponse =
      zio.aws.transfer.model.TestIdentityProviderResponse(
        response.map(value => value),
        statusCode,
        message.map(value => value),
        url
      )
    def response: Option[Response]
    def statusCode: StatusCode
    def message: Option[Message]
    def url: Url
    def getResponse: ZIO[Any, AwsError, Response] =
      AwsError.unwrapOptionField("response", response)
    def getStatusCode: ZIO[Any, Nothing, StatusCode] = ZIO.succeed(statusCode)
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
    def getUrl: ZIO[Any, Nothing, Url] = ZIO.succeed(url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.TestIdentityProviderResponse
  ) extends zio.aws.transfer.model.TestIdentityProviderResponse.ReadOnly {
    override val response: Option[Response] = scala
      .Option(impl.response())
      .map(value => zio.aws.transfer.model.primitives.Response(value))
    override val statusCode: StatusCode =
      zio.aws.transfer.model.primitives.StatusCode(impl.statusCode())
    override val message: Option[Message] = scala
      .Option(impl.message())
      .map(value => zio.aws.transfer.model.primitives.Message(value))
    override val url: Url = zio.aws.transfer.model.primitives.Url(impl.url())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.TestIdentityProviderResponse
  ): zio.aws.transfer.model.TestIdentityProviderResponse.ReadOnly = new Wrapper(
    impl
  )
}
