package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{
  ServerId,
  HomeDirectory,
  Policy,
  ExternalId,
  Role
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateAccessRequest(
    homeDirectory: Option[HomeDirectory] = None,
    homeDirectoryType: Option[zio.aws.transfer.model.HomeDirectoryType] = None,
    homeDirectoryMappings: Option[
      Iterable[zio.aws.transfer.model.HomeDirectoryMapEntry]
    ] = None,
    policy: Option[Policy] = None,
    posixProfile: Option[zio.aws.transfer.model.PosixProfile] = None,
    role: Option[Role] = None,
    serverId: ServerId,
    externalId: ExternalId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.UpdateAccessRequest = {
    import UpdateAccessRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.UpdateAccessRequest
      .builder()
      .optionallyWith(
        homeDirectory.map(value =>
          HomeDirectory.unwrap(value): java.lang.String
        )
      )(_.homeDirectory)
      .optionallyWith(homeDirectoryType.map(value => value.unwrap))(
        _.homeDirectoryType
      )
      .optionallyWith(
        homeDirectoryMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.homeDirectoryMappings)
      .optionallyWith(
        policy.map(value => Policy.unwrap(value): java.lang.String)
      )(_.policy)
      .optionallyWith(posixProfile.map(value => value.buildAwsValue()))(
        _.posixProfile
      )
      .optionallyWith(role.map(value => Role.unwrap(value): java.lang.String))(
        _.role
      )
      .serverId(ServerId.unwrap(serverId): java.lang.String)
      .externalId(ExternalId.unwrap(externalId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.UpdateAccessRequest.ReadOnly =
    zio.aws.transfer.model.UpdateAccessRequest.wrap(buildAwsValue())
}
object UpdateAccessRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.UpdateAccessRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.UpdateAccessRequest =
      zio.aws.transfer.model.UpdateAccessRequest(
        homeDirectory.map(value => value),
        homeDirectoryType.map(value => value),
        homeDirectoryMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        policy.map(value => value),
        posixProfile.map(value => value.asEditable),
        role.map(value => value),
        serverId,
        externalId
      )
    def homeDirectory: Option[HomeDirectory]
    def homeDirectoryType: Option[zio.aws.transfer.model.HomeDirectoryType]
    def homeDirectoryMappings
        : Option[List[zio.aws.transfer.model.HomeDirectoryMapEntry.ReadOnly]]
    def policy: Option[Policy]
    def posixProfile: Option[zio.aws.transfer.model.PosixProfile.ReadOnly]
    def role: Option[Role]
    def serverId: ServerId
    def externalId: ExternalId
    def getHomeDirectory: ZIO[Any, AwsError, HomeDirectory] =
      AwsError.unwrapOptionField("homeDirectory", homeDirectory)
    def getHomeDirectoryType
        : ZIO[Any, AwsError, zio.aws.transfer.model.HomeDirectoryType] =
      AwsError.unwrapOptionField("homeDirectoryType", homeDirectoryType)
    def getHomeDirectoryMappings: ZIO[Any, AwsError, List[
      zio.aws.transfer.model.HomeDirectoryMapEntry.ReadOnly
    ]] =
      AwsError.unwrapOptionField("homeDirectoryMappings", homeDirectoryMappings)
    def getPolicy: ZIO[Any, AwsError, Policy] =
      AwsError.unwrapOptionField("policy", policy)
    def getPosixProfile
        : ZIO[Any, AwsError, zio.aws.transfer.model.PosixProfile.ReadOnly] =
      AwsError.unwrapOptionField("posixProfile", posixProfile)
    def getRole: ZIO[Any, AwsError, Role] =
      AwsError.unwrapOptionField("role", role)
    def getServerId: ZIO[Any, Nothing, ServerId] = ZIO.succeed(serverId)
    def getExternalId: ZIO[Any, Nothing, ExternalId] = ZIO.succeed(externalId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.UpdateAccessRequest
  ) extends zio.aws.transfer.model.UpdateAccessRequest.ReadOnly {
    override val homeDirectory: Option[HomeDirectory] = scala
      .Option(impl.homeDirectory())
      .map(value => zio.aws.transfer.model.primitives.HomeDirectory(value))
    override val homeDirectoryType
        : Option[zio.aws.transfer.model.HomeDirectoryType] = scala
      .Option(impl.homeDirectoryType())
      .map(value => zio.aws.transfer.model.HomeDirectoryType.wrap(value))
    override val homeDirectoryMappings
        : Option[List[zio.aws.transfer.model.HomeDirectoryMapEntry.ReadOnly]] =
      scala
        .Option(impl.homeDirectoryMappings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transfer.model.HomeDirectoryMapEntry.wrap(item)
          }.toList
        )
    override val policy: Option[Policy] = scala
      .Option(impl.policy())
      .map(value => zio.aws.transfer.model.primitives.Policy(value))
    override val posixProfile
        : Option[zio.aws.transfer.model.PosixProfile.ReadOnly] = scala
      .Option(impl.posixProfile())
      .map(value => zio.aws.transfer.model.PosixProfile.wrap(value))
    override val role: Option[Role] = scala
      .Option(impl.role())
      .map(value => zio.aws.transfer.model.primitives.Role(value))
    override val serverId: ServerId =
      zio.aws.transfer.model.primitives.ServerId(impl.serverId())
    override val externalId: ExternalId =
      zio.aws.transfer.model.primitives.ExternalId(impl.externalId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.UpdateAccessRequest
  ): zio.aws.transfer.model.UpdateAccessRequest.ReadOnly = new Wrapper(impl)
}
