package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{
  Certificate,
  PostAuthenticationLoginBanner,
  ServerId,
  PreAuthenticationLoginBanner,
  NullableRole,
  SecurityPolicyName,
  HostKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateServerRequest(
    certificate: Option[Certificate] = None,
    protocolDetails: Option[zio.aws.transfer.model.ProtocolDetails] = None,
    endpointDetails: Option[zio.aws.transfer.model.EndpointDetails] = None,
    endpointType: Option[zio.aws.transfer.model.EndpointType] = None,
    hostKey: Option[HostKey] = None,
    identityProviderDetails: Option[
      zio.aws.transfer.model.IdentityProviderDetails
    ] = None,
    loggingRole: Option[NullableRole] = None,
    postAuthenticationLoginBanner: Option[PostAuthenticationLoginBanner] = None,
    preAuthenticationLoginBanner: Option[PreAuthenticationLoginBanner] = None,
    protocols: Option[Iterable[zio.aws.transfer.model.Protocol]] = None,
    securityPolicyName: Option[SecurityPolicyName] = None,
    serverId: ServerId,
    workflowDetails: Option[zio.aws.transfer.model.WorkflowDetails] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.UpdateServerRequest = {
    import UpdateServerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.UpdateServerRequest
      .builder()
      .optionallyWith(
        certificate.map(value => Certificate.unwrap(value): java.lang.String)
      )(_.certificate)
      .optionallyWith(protocolDetails.map(value => value.buildAwsValue()))(
        _.protocolDetails
      )
      .optionallyWith(endpointDetails.map(value => value.buildAwsValue()))(
        _.endpointDetails
      )
      .optionallyWith(endpointType.map(value => value.unwrap))(_.endpointType)
      .optionallyWith(
        hostKey.map(value => HostKey.unwrap(value): java.lang.String)
      )(_.hostKey)
      .optionallyWith(
        identityProviderDetails.map(value => value.buildAwsValue())
      )(_.identityProviderDetails)
      .optionallyWith(
        loggingRole.map(value => NullableRole.unwrap(value): java.lang.String)
      )(_.loggingRole)
      .optionallyWith(
        postAuthenticationLoginBanner.map(value =>
          PostAuthenticationLoginBanner.unwrap(value): java.lang.String
        )
      )(_.postAuthenticationLoginBanner)
      .optionallyWith(
        preAuthenticationLoginBanner.map(value =>
          PreAuthenticationLoginBanner.unwrap(value): java.lang.String
        )
      )(_.preAuthenticationLoginBanner)
      .optionallyWith(
        protocols.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.protocolsWithStrings)
      .optionallyWith(
        securityPolicyName.map(value =>
          SecurityPolicyName.unwrap(value): java.lang.String
        )
      )(_.securityPolicyName)
      .serverId(ServerId.unwrap(serverId): java.lang.String)
      .optionallyWith(workflowDetails.map(value => value.buildAwsValue()))(
        _.workflowDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.UpdateServerRequest.ReadOnly =
    zio.aws.transfer.model.UpdateServerRequest.wrap(buildAwsValue())
}
object UpdateServerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.UpdateServerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.UpdateServerRequest =
      zio.aws.transfer.model.UpdateServerRequest(
        certificate.map(value => value),
        protocolDetails.map(value => value.asEditable),
        endpointDetails.map(value => value.asEditable),
        endpointType.map(value => value),
        hostKey.map(value => value),
        identityProviderDetails.map(value => value.asEditable),
        loggingRole.map(value => value),
        postAuthenticationLoginBanner.map(value => value),
        preAuthenticationLoginBanner.map(value => value),
        protocols.map(value => value),
        securityPolicyName.map(value => value),
        serverId,
        workflowDetails.map(value => value.asEditable)
      )
    def certificate: Option[Certificate]
    def protocolDetails: Option[zio.aws.transfer.model.ProtocolDetails.ReadOnly]
    def endpointDetails: Option[zio.aws.transfer.model.EndpointDetails.ReadOnly]
    def endpointType: Option[zio.aws.transfer.model.EndpointType]
    def hostKey: Option[HostKey]
    def identityProviderDetails
        : Option[zio.aws.transfer.model.IdentityProviderDetails.ReadOnly]
    def loggingRole: Option[NullableRole]
    def postAuthenticationLoginBanner: Option[PostAuthenticationLoginBanner]
    def preAuthenticationLoginBanner: Option[PreAuthenticationLoginBanner]
    def protocols: Option[List[zio.aws.transfer.model.Protocol]]
    def securityPolicyName: Option[SecurityPolicyName]
    def serverId: ServerId
    def workflowDetails: Option[zio.aws.transfer.model.WorkflowDetails.ReadOnly]
    def getCertificate: ZIO[Any, AwsError, Certificate] =
      AwsError.unwrapOptionField("certificate", certificate)
    def getProtocolDetails
        : ZIO[Any, AwsError, zio.aws.transfer.model.ProtocolDetails.ReadOnly] =
      AwsError.unwrapOptionField("protocolDetails", protocolDetails)
    def getEndpointDetails
        : ZIO[Any, AwsError, zio.aws.transfer.model.EndpointDetails.ReadOnly] =
      AwsError.unwrapOptionField("endpointDetails", endpointDetails)
    def getEndpointType
        : ZIO[Any, AwsError, zio.aws.transfer.model.EndpointType] =
      AwsError.unwrapOptionField("endpointType", endpointType)
    def getHostKey: ZIO[Any, AwsError, HostKey] =
      AwsError.unwrapOptionField("hostKey", hostKey)
    def getIdentityProviderDetails: ZIO[
      Any,
      AwsError,
      zio.aws.transfer.model.IdentityProviderDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "identityProviderDetails",
      identityProviderDetails
    )
    def getLoggingRole: ZIO[Any, AwsError, NullableRole] =
      AwsError.unwrapOptionField("loggingRole", loggingRole)
    def getPostAuthenticationLoginBanner
        : ZIO[Any, AwsError, PostAuthenticationLoginBanner] =
      AwsError.unwrapOptionField(
        "postAuthenticationLoginBanner",
        postAuthenticationLoginBanner
      )
    def getPreAuthenticationLoginBanner
        : ZIO[Any, AwsError, PreAuthenticationLoginBanner] =
      AwsError.unwrapOptionField(
        "preAuthenticationLoginBanner",
        preAuthenticationLoginBanner
      )
    def getProtocols
        : ZIO[Any, AwsError, List[zio.aws.transfer.model.Protocol]] =
      AwsError.unwrapOptionField("protocols", protocols)
    def getSecurityPolicyName: ZIO[Any, AwsError, SecurityPolicyName] =
      AwsError.unwrapOptionField("securityPolicyName", securityPolicyName)
    def getServerId: ZIO[Any, Nothing, ServerId] = ZIO.succeed(serverId)
    def getWorkflowDetails
        : ZIO[Any, AwsError, zio.aws.transfer.model.WorkflowDetails.ReadOnly] =
      AwsError.unwrapOptionField("workflowDetails", workflowDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.UpdateServerRequest
  ) extends zio.aws.transfer.model.UpdateServerRequest.ReadOnly {
    override val certificate: Option[Certificate] = scala
      .Option(impl.certificate())
      .map(value => zio.aws.transfer.model.primitives.Certificate(value))
    override val protocolDetails
        : Option[zio.aws.transfer.model.ProtocolDetails.ReadOnly] = scala
      .Option(impl.protocolDetails())
      .map(value => zio.aws.transfer.model.ProtocolDetails.wrap(value))
    override val endpointDetails
        : Option[zio.aws.transfer.model.EndpointDetails.ReadOnly] = scala
      .Option(impl.endpointDetails())
      .map(value => zio.aws.transfer.model.EndpointDetails.wrap(value))
    override val endpointType: Option[zio.aws.transfer.model.EndpointType] =
      scala
        .Option(impl.endpointType())
        .map(value => zio.aws.transfer.model.EndpointType.wrap(value))
    override val hostKey: Option[HostKey] = scala
      .Option(impl.hostKey())
      .map(value => zio.aws.transfer.model.primitives.HostKey(value))
    override val identityProviderDetails
        : Option[zio.aws.transfer.model.IdentityProviderDetails.ReadOnly] =
      scala
        .Option(impl.identityProviderDetails())
        .map(value =>
          zio.aws.transfer.model.IdentityProviderDetails.wrap(value)
        )
    override val loggingRole: Option[NullableRole] = scala
      .Option(impl.loggingRole())
      .map(value => zio.aws.transfer.model.primitives.NullableRole(value))
    override val postAuthenticationLoginBanner
        : Option[PostAuthenticationLoginBanner] = scala
      .Option(impl.postAuthenticationLoginBanner())
      .map(value =>
        zio.aws.transfer.model.primitives.PostAuthenticationLoginBanner(value)
      )
    override val preAuthenticationLoginBanner
        : Option[PreAuthenticationLoginBanner] = scala
      .Option(impl.preAuthenticationLoginBanner())
      .map(value =>
        zio.aws.transfer.model.primitives.PreAuthenticationLoginBanner(value)
      )
    override val protocols: Option[List[zio.aws.transfer.model.Protocol]] =
      scala
        .Option(impl.protocols())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transfer.model.Protocol.wrap(item)
          }.toList
        )
    override val securityPolicyName: Option[SecurityPolicyName] = scala
      .Option(impl.securityPolicyName())
      .map(value => zio.aws.transfer.model.primitives.SecurityPolicyName(value))
    override val serverId: ServerId =
      zio.aws.transfer.model.primitives.ServerId(impl.serverId())
    override val workflowDetails
        : Option[zio.aws.transfer.model.WorkflowDetails.ReadOnly] = scala
      .Option(impl.workflowDetails())
      .map(value => zio.aws.transfer.model.WorkflowDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.UpdateServerRequest
  ): zio.aws.transfer.model.UpdateServerRequest.ReadOnly = new Wrapper(impl)
}
