package zio.aws.transfer.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class WorkflowDetails(
    onUpload: Iterable[zio.aws.transfer.model.WorkflowDetail]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.WorkflowDetails = {
    import WorkflowDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.WorkflowDetails
      .builder()
      .onUpload(onUpload.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.WorkflowDetails.ReadOnly =
    zio.aws.transfer.model.WorkflowDetails.wrap(buildAwsValue())
}
object WorkflowDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.WorkflowDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.WorkflowDetails =
      zio.aws.transfer.model.WorkflowDetails(onUpload.map { item =>
        item.asEditable
      })
    def onUpload: List[zio.aws.transfer.model.WorkflowDetail.ReadOnly]
    def getOnUpload: ZIO[Any, Nothing, List[
      zio.aws.transfer.model.WorkflowDetail.ReadOnly
    ]] = ZIO.succeed(onUpload)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.WorkflowDetails
  ) extends zio.aws.transfer.model.WorkflowDetails.ReadOnly {
    override val onUpload
        : List[zio.aws.transfer.model.WorkflowDetail.ReadOnly] = impl
      .onUpload()
      .asScala
      .map { item =>
        zio.aws.transfer.model.WorkflowDetail.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.WorkflowDetails
  ): zio.aws.transfer.model.WorkflowDetails.ReadOnly = new Wrapper(impl)
}
