package zio.aws.transfer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class WorkflowStep(
    `type`: Option[zio.aws.transfer.model.WorkflowStepType] = None,
    copyStepDetails: Option[zio.aws.transfer.model.CopyStepDetails] = None,
    customStepDetails: Option[zio.aws.transfer.model.CustomStepDetails] = None,
    deleteStepDetails: Option[zio.aws.transfer.model.DeleteStepDetails] = None,
    tagStepDetails: Option[zio.aws.transfer.model.TagStepDetails] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.WorkflowStep = {
    import WorkflowStep.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.WorkflowStep
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(copyStepDetails.map(value => value.buildAwsValue()))(
        _.copyStepDetails
      )
      .optionallyWith(customStepDetails.map(value => value.buildAwsValue()))(
        _.customStepDetails
      )
      .optionallyWith(deleteStepDetails.map(value => value.buildAwsValue()))(
        _.deleteStepDetails
      )
      .optionallyWith(tagStepDetails.map(value => value.buildAwsValue()))(
        _.tagStepDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.WorkflowStep.ReadOnly =
    zio.aws.transfer.model.WorkflowStep.wrap(buildAwsValue())
}
object WorkflowStep {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.WorkflowStep
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.WorkflowStep =
      zio.aws.transfer.model.WorkflowStep(
        `type`.map(value => value),
        copyStepDetails.map(value => value.asEditable),
        customStepDetails.map(value => value.asEditable),
        deleteStepDetails.map(value => value.asEditable),
        tagStepDetails.map(value => value.asEditable)
      )
    def `type`: Option[zio.aws.transfer.model.WorkflowStepType]
    def copyStepDetails: Option[zio.aws.transfer.model.CopyStepDetails.ReadOnly]
    def customStepDetails
        : Option[zio.aws.transfer.model.CustomStepDetails.ReadOnly]
    def deleteStepDetails
        : Option[zio.aws.transfer.model.DeleteStepDetails.ReadOnly]
    def tagStepDetails: Option[zio.aws.transfer.model.TagStepDetails.ReadOnly]
    def getType: ZIO[Any, AwsError, zio.aws.transfer.model.WorkflowStepType] =
      AwsError.unwrapOptionField("type", `type`)
    def getCopyStepDetails
        : ZIO[Any, AwsError, zio.aws.transfer.model.CopyStepDetails.ReadOnly] =
      AwsError.unwrapOptionField("copyStepDetails", copyStepDetails)
    def getCustomStepDetails: ZIO[
      Any,
      AwsError,
      zio.aws.transfer.model.CustomStepDetails.ReadOnly
    ] = AwsError.unwrapOptionField("customStepDetails", customStepDetails)
    def getDeleteStepDetails: ZIO[
      Any,
      AwsError,
      zio.aws.transfer.model.DeleteStepDetails.ReadOnly
    ] = AwsError.unwrapOptionField("deleteStepDetails", deleteStepDetails)
    def getTagStepDetails
        : ZIO[Any, AwsError, zio.aws.transfer.model.TagStepDetails.ReadOnly] =
      AwsError.unwrapOptionField("tagStepDetails", tagStepDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.WorkflowStep
  ) extends zio.aws.transfer.model.WorkflowStep.ReadOnly {
    override val `type`: Option[zio.aws.transfer.model.WorkflowStepType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.transfer.model.WorkflowStepType.wrap(value))
    override val copyStepDetails
        : Option[zio.aws.transfer.model.CopyStepDetails.ReadOnly] = scala
      .Option(impl.copyStepDetails())
      .map(value => zio.aws.transfer.model.CopyStepDetails.wrap(value))
    override val customStepDetails
        : Option[zio.aws.transfer.model.CustomStepDetails.ReadOnly] = scala
      .Option(impl.customStepDetails())
      .map(value => zio.aws.transfer.model.CustomStepDetails.wrap(value))
    override val deleteStepDetails
        : Option[zio.aws.transfer.model.DeleteStepDetails.ReadOnly] = scala
      .Option(impl.deleteStepDetails())
      .map(value => zio.aws.transfer.model.DeleteStepDetails.wrap(value))
    override val tagStepDetails
        : Option[zio.aws.transfer.model.TagStepDetails.ReadOnly] = scala
      .Option(impl.tagStepDetails())
      .map(value => zio.aws.transfer.model.TagStepDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.WorkflowStep
  ): zio.aws.transfer.model.WorkflowStep.ReadOnly = new Wrapper(impl)
}
