package zio.aws.transfer
import zio.aws.transfer.model.DescribeExecutionResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.transfer.TransferAsyncClient
import zio.aws.transfer.model.{
  DeleteUserRequest,
  ListServersRequest,
  CreateWorkflowRequest,
  CreateAccessRequest,
  DescribeUserRequest,
  DescribeServerRequest,
  StopServerRequest,
  DeleteSshPublicKeyRequest,
  UpdateAccessRequest,
  ListSecurityPoliciesRequest,
  ListUsersRequest,
  ListWorkflowsRequest,
  ListTagsForResourceRequest,
  DeleteServerRequest,
  CreateUserRequest,
  DescribeWorkflowRequest,
  ListExecutionsRequest,
  DeleteAccessRequest,
  UpdateServerRequest,
  SendWorkflowStepStateRequest,
  ListAccessesRequest,
  DescribeAccessRequest,
  UntagResourceRequest,
  DescribeSecurityPolicyRequest,
  ImportSshPublicKeyRequest,
  UpdateUserRequest,
  CreateServerRequest,
  DeleteWorkflowRequest,
  DescribeExecutionRequest,
  TagResourceRequest,
  StartServerRequest,
  TestIdentityProviderRequest
}
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.core.aspects.AwsCallAspect
import zio.{ZIO, IO, ZEnvironment, URLayer}
import zio.stream.ZStream
import zio.aws.transfer.model.primitives.SecurityPolicyName
object TransferMock extends Mock[Transfer] {
  object UpdateServer
      extends Effect[
        UpdateServerRequest,
        AwsError,
        zio.aws.transfer.model.UpdateServerResponse.ReadOnly
      ]
  object ListUsers
      extends Effect[ListUsersRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.transfer.model.ListUsersResponse.ReadOnly,
        zio.aws.transfer.model.ListedUser.ReadOnly
      ]]
  object ListUsersPaginated
      extends Effect[
        ListUsersRequest,
        AwsError,
        zio.aws.transfer.model.ListUsersResponse.ReadOnly
      ]
  object UpdateUser
      extends Effect[
        UpdateUserRequest,
        AwsError,
        zio.aws.transfer.model.UpdateUserResponse.ReadOnly
      ]
  object DeleteServer extends Effect[DeleteServerRequest, AwsError, Unit]
  object DescribeWorkflow
      extends Effect[
        DescribeWorkflowRequest,
        AwsError,
        zio.aws.transfer.model.DescribeWorkflowResponse.ReadOnly
      ]
  object DescribeServer
      extends Effect[
        DescribeServerRequest,
        AwsError,
        zio.aws.transfer.model.DescribeServerResponse.ReadOnly
      ]
  object ListSecurityPolicies
      extends Stream[ListSecurityPoliciesRequest, AwsError, SecurityPolicyName]
  object ListSecurityPoliciesPaginated
      extends Effect[
        ListSecurityPoliciesRequest,
        AwsError,
        zio.aws.transfer.model.ListSecurityPoliciesResponse.ReadOnly
      ]
  object CreateAccess
      extends Effect[
        CreateAccessRequest,
        AwsError,
        zio.aws.transfer.model.CreateAccessResponse.ReadOnly
      ]
  object StartServer extends Effect[StartServerRequest, AwsError, Unit]
  object ImportSshPublicKey
      extends Effect[
        ImportSshPublicKeyRequest,
        AwsError,
        zio.aws.transfer.model.ImportSshPublicKeyResponse.ReadOnly
      ]
  object DescribeExecution
      extends Effect[DescribeExecutionRequest, AwsError, ReadOnly]
  object CreateUser
      extends Effect[
        CreateUserRequest,
        AwsError,
        zio.aws.transfer.model.CreateUserResponse.ReadOnly
      ]
  object StopServer extends Effect[StopServerRequest, AwsError, Unit]
  object ListAccesses
      extends Effect[ListAccessesRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.transfer.model.ListAccessesResponse.ReadOnly,
        zio.aws.transfer.model.ListedAccess.ReadOnly
      ]]
  object ListAccessesPaginated
      extends Effect[
        ListAccessesRequest,
        AwsError,
        zio.aws.transfer.model.ListAccessesResponse.ReadOnly
      ]
  object DescribeAccess
      extends Effect[
        DescribeAccessRequest,
        AwsError,
        zio.aws.transfer.model.DescribeAccessResponse.ReadOnly
      ]
  object SendWorkflowStepState
      extends Effect[
        SendWorkflowStepStateRequest,
        AwsError,
        zio.aws.transfer.model.SendWorkflowStepStateResponse.ReadOnly
      ]
  object DeleteAccess extends Effect[DeleteAccessRequest, AwsError, Unit]
  object UntagResource extends Effect[UntagResourceRequest, AwsError, Unit]
  object ListExecutions
      extends Effect[ListExecutionsRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.transfer.model.ListExecutionsResponse.ReadOnly,
        zio.aws.transfer.model.ListedExecution.ReadOnly
      ]]
  object ListExecutionsPaginated
      extends Effect[
        ListExecutionsRequest,
        AwsError,
        zio.aws.transfer.model.ListExecutionsResponse.ReadOnly
      ]
  object DescribeUser
      extends Effect[
        DescribeUserRequest,
        AwsError,
        zio.aws.transfer.model.DescribeUserResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.transfer.model.ListTagsForResourceResponse.ReadOnly,
          zio.aws.transfer.model.Tag.ReadOnly
        ]
      ]
  object ListTagsForResourcePaginated
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.transfer.model.ListTagsForResourceResponse.ReadOnly
      ]
  object CreateServer
      extends Effect[
        CreateServerRequest,
        AwsError,
        zio.aws.transfer.model.CreateServerResponse.ReadOnly
      ]
  object TagResource extends Effect[TagResourceRequest, AwsError, Unit]
  object TestIdentityProvider
      extends Effect[
        TestIdentityProviderRequest,
        AwsError,
        zio.aws.transfer.model.TestIdentityProviderResponse.ReadOnly
      ]
  object UpdateAccess
      extends Effect[
        UpdateAccessRequest,
        AwsError,
        zio.aws.transfer.model.UpdateAccessResponse.ReadOnly
      ]
  object ListWorkflows
      extends Stream[
        ListWorkflowsRequest,
        AwsError,
        zio.aws.transfer.model.ListedWorkflow.ReadOnly
      ]
  object ListWorkflowsPaginated
      extends Effect[
        ListWorkflowsRequest,
        AwsError,
        zio.aws.transfer.model.ListWorkflowsResponse.ReadOnly
      ]
  object DeleteUser extends Effect[DeleteUserRequest, AwsError, Unit]
  object DescribeSecurityPolicy
      extends Effect[
        DescribeSecurityPolicyRequest,
        AwsError,
        zio.aws.transfer.model.DescribeSecurityPolicyResponse.ReadOnly
      ]
  object DeleteSshPublicKey
      extends Effect[DeleteSshPublicKeyRequest, AwsError, Unit]
  object DeleteWorkflow extends Effect[DeleteWorkflowRequest, AwsError, Unit]
  object CreateWorkflow
      extends Effect[
        CreateWorkflowRequest,
        AwsError,
        zio.aws.transfer.model.CreateWorkflowResponse.ReadOnly
      ]
  object ListServers
      extends Stream[
        ListServersRequest,
        AwsError,
        zio.aws.transfer.model.ListedServer.ReadOnly
      ]
  object ListServersPaginated
      extends Effect[
        ListServersRequest,
        AwsError,
        zio.aws.transfer.model.ListServersResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Transfer] = zio.ZLayer {
    ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new Transfer {
          val api: TransferAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : Transfer = this
          def updateServer(request: UpdateServerRequest): IO[
            AwsError,
            zio.aws.transfer.model.UpdateServerResponse.ReadOnly
          ] = proxy(UpdateServer, request)
          def listUsers(
              request: ListUsersRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.transfer.model.ListUsersResponse.ReadOnly,
            zio.aws.transfer.model.ListedUser.ReadOnly
          ]] = proxy(ListUsers, request)
          def listUsersPaginated(
              request: ListUsersRequest
          ): IO[AwsError, zio.aws.transfer.model.ListUsersResponse.ReadOnly] =
            proxy(ListUsersPaginated, request)
          def updateUser(
              request: UpdateUserRequest
          ): IO[AwsError, zio.aws.transfer.model.UpdateUserResponse.ReadOnly] =
            proxy(UpdateUser, request)
          def deleteServer(request: DeleteServerRequest): IO[AwsError, Unit] =
            proxy(DeleteServer, request)
          def describeWorkflow(request: DescribeWorkflowRequest): IO[
            AwsError,
            zio.aws.transfer.model.DescribeWorkflowResponse.ReadOnly
          ] = proxy(DescribeWorkflow, request)
          def describeServer(request: DescribeServerRequest): IO[
            AwsError,
            zio.aws.transfer.model.DescribeServerResponse.ReadOnly
          ] = proxy(DescribeServer, request)
          def listSecurityPolicies(
              request: ListSecurityPoliciesRequest
          ): ZStream[Any, AwsError, SecurityPolicyName] =
            rts.unsafeRun(proxy(ListSecurityPolicies, request))
          def listSecurityPoliciesPaginated(
              request: ListSecurityPoliciesRequest
          ): IO[
            AwsError,
            zio.aws.transfer.model.ListSecurityPoliciesResponse.ReadOnly
          ] = proxy(ListSecurityPoliciesPaginated, request)
          def createAccess(request: CreateAccessRequest): IO[
            AwsError,
            zio.aws.transfer.model.CreateAccessResponse.ReadOnly
          ] = proxy(CreateAccess, request)
          def startServer(request: StartServerRequest): IO[AwsError, Unit] =
            proxy(StartServer, request)
          def importSshPublicKey(request: ImportSshPublicKeyRequest): IO[
            AwsError,
            zio.aws.transfer.model.ImportSshPublicKeyResponse.ReadOnly
          ] = proxy(ImportSshPublicKey, request)
          def describeExecution(
              request: DescribeExecutionRequest
          ): IO[AwsError, ReadOnly] = proxy(DescribeExecution, request)
          def createUser(
              request: CreateUserRequest
          ): IO[AwsError, zio.aws.transfer.model.CreateUserResponse.ReadOnly] =
            proxy(CreateUser, request)
          def stopServer(request: StopServerRequest): IO[AwsError, Unit] =
            proxy(StopServer, request)
          def listAccesses(
              request: ListAccessesRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.transfer.model.ListAccessesResponse.ReadOnly,
            zio.aws.transfer.model.ListedAccess.ReadOnly
          ]] = proxy(ListAccesses, request)
          def listAccessesPaginated(request: ListAccessesRequest): IO[
            AwsError,
            zio.aws.transfer.model.ListAccessesResponse.ReadOnly
          ] = proxy(ListAccessesPaginated, request)
          def describeAccess(request: DescribeAccessRequest): IO[
            AwsError,
            zio.aws.transfer.model.DescribeAccessResponse.ReadOnly
          ] = proxy(DescribeAccess, request)
          def sendWorkflowStepState(request: SendWorkflowStepStateRequest): IO[
            AwsError,
            zio.aws.transfer.model.SendWorkflowStepStateResponse.ReadOnly
          ] = proxy(SendWorkflowStepState, request)
          def deleteAccess(request: DeleteAccessRequest): IO[AwsError, Unit] =
            proxy(DeleteAccess, request)
          def untagResource(request: UntagResourceRequest): IO[AwsError, Unit] =
            proxy(UntagResource, request)
          def listExecutions(
              request: ListExecutionsRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.transfer.model.ListExecutionsResponse.ReadOnly,
            zio.aws.transfer.model.ListedExecution.ReadOnly
          ]] = proxy(ListExecutions, request)
          def listExecutionsPaginated(request: ListExecutionsRequest): IO[
            AwsError,
            zio.aws.transfer.model.ListExecutionsResponse.ReadOnly
          ] = proxy(ListExecutionsPaginated, request)
          def describeUser(request: DescribeUserRequest): IO[
            AwsError,
            zio.aws.transfer.model.DescribeUserResponse.ReadOnly
          ] = proxy(DescribeUser, request)
          def listTagsForResource(
              request: ListTagsForResourceRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.transfer.model.ListTagsForResourceResponse.ReadOnly,
            zio.aws.transfer.model.Tag.ReadOnly
          ]] = proxy(ListTagsForResource, request)
          def listTagsForResourcePaginated(
              request: ListTagsForResourceRequest
          ): IO[
            AwsError,
            zio.aws.transfer.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResourcePaginated, request)
          def createServer(request: CreateServerRequest): IO[
            AwsError,
            zio.aws.transfer.model.CreateServerResponse.ReadOnly
          ] = proxy(CreateServer, request)
          def tagResource(request: TagResourceRequest): IO[AwsError, Unit] =
            proxy(TagResource, request)
          def testIdentityProvider(request: TestIdentityProviderRequest): IO[
            AwsError,
            zio.aws.transfer.model.TestIdentityProviderResponse.ReadOnly
          ] = proxy(TestIdentityProvider, request)
          def updateAccess(request: UpdateAccessRequest): IO[
            AwsError,
            zio.aws.transfer.model.UpdateAccessResponse.ReadOnly
          ] = proxy(UpdateAccess, request)
          def listWorkflows(request: ListWorkflowsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.transfer.model.ListedWorkflow.ReadOnly
          ] = rts.unsafeRun(proxy(ListWorkflows, request))
          def listWorkflowsPaginated(request: ListWorkflowsRequest): IO[
            AwsError,
            zio.aws.transfer.model.ListWorkflowsResponse.ReadOnly
          ] = proxy(ListWorkflowsPaginated, request)
          def deleteUser(request: DeleteUserRequest): IO[AwsError, Unit] =
            proxy(DeleteUser, request)
          def describeSecurityPolicy(
              request: DescribeSecurityPolicyRequest
          ): IO[
            AwsError,
            zio.aws.transfer.model.DescribeSecurityPolicyResponse.ReadOnly
          ] = proxy(DescribeSecurityPolicy, request)
          def deleteSshPublicKey(
              request: DeleteSshPublicKeyRequest
          ): IO[AwsError, Unit] = proxy(DeleteSshPublicKey, request)
          def deleteWorkflow(
              request: DeleteWorkflowRequest
          ): IO[AwsError, Unit] = proxy(DeleteWorkflow, request)
          def createWorkflow(request: CreateWorkflowRequest): IO[
            AwsError,
            zio.aws.transfer.model.CreateWorkflowResponse.ReadOnly
          ] = proxy(CreateWorkflow, request)
          def listServers(request: ListServersRequest): ZStream[
            Any,
            AwsError,
            zio.aws.transfer.model.ListedServer.ReadOnly
          ] = rts.unsafeRun(proxy(ListServers, request))
          def listServersPaginated(
              request: ListServersRequest
          ): IO[AwsError, zio.aws.transfer.model.ListServersResponse.ReadOnly] =
            proxy(ListServersPaginated, request)
        }
      }
    }
  }
}
