package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{
  ServerId,
  HomeDirectory,
  Policy,
  ExternalId,
  Role
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateAccessRequest(
    homeDirectory: Optional[HomeDirectory] = Optional.Absent,
    homeDirectoryType: Optional[zio.aws.transfer.model.HomeDirectoryType] =
      Optional.Absent,
    homeDirectoryMappings: Optional[
      Iterable[zio.aws.transfer.model.HomeDirectoryMapEntry]
    ] = Optional.Absent,
    policy: Optional[Policy] = Optional.Absent,
    posixProfile: Optional[zio.aws.transfer.model.PosixProfile] =
      Optional.Absent,
    role: Role,
    serverId: ServerId,
    externalId: ExternalId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.CreateAccessRequest = {
    import CreateAccessRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.CreateAccessRequest
      .builder()
      .optionallyWith(
        homeDirectory.map(value =>
          HomeDirectory.unwrap(value): java.lang.String
        )
      )(_.homeDirectory)
      .optionallyWith(homeDirectoryType.map(value => value.unwrap))(
        _.homeDirectoryType
      )
      .optionallyWith(
        homeDirectoryMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.homeDirectoryMappings)
      .optionallyWith(
        policy.map(value => Policy.unwrap(value): java.lang.String)
      )(_.policy)
      .optionallyWith(posixProfile.map(value => value.buildAwsValue()))(
        _.posixProfile
      )
      .role(Role.unwrap(role): java.lang.String)
      .serverId(ServerId.unwrap(serverId): java.lang.String)
      .externalId(ExternalId.unwrap(externalId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.CreateAccessRequest.ReadOnly =
    zio.aws.transfer.model.CreateAccessRequest.wrap(buildAwsValue())
}
object CreateAccessRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.CreateAccessRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.CreateAccessRequest =
      zio.aws.transfer.model.CreateAccessRequest(
        homeDirectory.map(value => value),
        homeDirectoryType.map(value => value),
        homeDirectoryMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        policy.map(value => value),
        posixProfile.map(value => value.asEditable),
        role,
        serverId,
        externalId
      )
    def homeDirectory: Optional[HomeDirectory]
    def homeDirectoryType: Optional[zio.aws.transfer.model.HomeDirectoryType]
    def homeDirectoryMappings
        : Optional[List[zio.aws.transfer.model.HomeDirectoryMapEntry.ReadOnly]]
    def policy: Optional[Policy]
    def posixProfile: Optional[zio.aws.transfer.model.PosixProfile.ReadOnly]
    def role: Role
    def serverId: ServerId
    def externalId: ExternalId
    def getHomeDirectory: ZIO[Any, AwsError, HomeDirectory] =
      AwsError.unwrapOptionField("homeDirectory", homeDirectory)
    def getHomeDirectoryType
        : ZIO[Any, AwsError, zio.aws.transfer.model.HomeDirectoryType] =
      AwsError.unwrapOptionField("homeDirectoryType", homeDirectoryType)
    def getHomeDirectoryMappings: ZIO[Any, AwsError, List[
      zio.aws.transfer.model.HomeDirectoryMapEntry.ReadOnly
    ]] =
      AwsError.unwrapOptionField("homeDirectoryMappings", homeDirectoryMappings)
    def getPolicy: ZIO[Any, AwsError, Policy] =
      AwsError.unwrapOptionField("policy", policy)
    def getPosixProfile
        : ZIO[Any, AwsError, zio.aws.transfer.model.PosixProfile.ReadOnly] =
      AwsError.unwrapOptionField("posixProfile", posixProfile)
    def getRole: ZIO[Any, Nothing, Role] = ZIO.succeed(role)
    def getServerId: ZIO[Any, Nothing, ServerId] = ZIO.succeed(serverId)
    def getExternalId: ZIO[Any, Nothing, ExternalId] = ZIO.succeed(externalId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.CreateAccessRequest
  ) extends zio.aws.transfer.model.CreateAccessRequest.ReadOnly {
    override val homeDirectory: Optional[HomeDirectory] = zio.aws.core.internal
      .optionalFromNullable(impl.homeDirectory())
      .map(value => zio.aws.transfer.model.primitives.HomeDirectory(value))
    override val homeDirectoryType
        : Optional[zio.aws.transfer.model.HomeDirectoryType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.homeDirectoryType())
        .map(value => zio.aws.transfer.model.HomeDirectoryType.wrap(value))
    override val homeDirectoryMappings: Optional[
      List[zio.aws.transfer.model.HomeDirectoryMapEntry.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.homeDirectoryMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transfer.model.HomeDirectoryMapEntry.wrap(item)
        }.toList
      )
    override val policy: Optional[Policy] = zio.aws.core.internal
      .optionalFromNullable(impl.policy())
      .map(value => zio.aws.transfer.model.primitives.Policy(value))
    override val posixProfile
        : Optional[zio.aws.transfer.model.PosixProfile.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.posixProfile())
        .map(value => zio.aws.transfer.model.PosixProfile.wrap(value))
    override val role: Role =
      zio.aws.transfer.model.primitives.Role(impl.role())
    override val serverId: ServerId =
      zio.aws.transfer.model.primitives.ServerId(impl.serverId())
    override val externalId: ExternalId =
      zio.aws.transfer.model.primitives.ExternalId(impl.externalId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.CreateAccessRequest
  ): zio.aws.transfer.model.CreateAccessRequest.ReadOnly = new Wrapper(impl)
}
