package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{
  Certificate,
  PostAuthenticationLoginBanner,
  PreAuthenticationLoginBanner,
  SecurityPolicyName,
  Role,
  HostKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateServerRequest(
    certificate: Optional[Certificate] = Optional.Absent,
    domain: Optional[zio.aws.transfer.model.Domain] = Optional.Absent,
    endpointDetails: Optional[zio.aws.transfer.model.EndpointDetails] =
      Optional.Absent,
    endpointType: Optional[zio.aws.transfer.model.EndpointType] =
      Optional.Absent,
    hostKey: Optional[HostKey] = Optional.Absent,
    identityProviderDetails: Optional[
      zio.aws.transfer.model.IdentityProviderDetails
    ] = Optional.Absent,
    identityProviderType: Optional[
      zio.aws.transfer.model.IdentityProviderType
    ] = Optional.Absent,
    loggingRole: Optional[Role] = Optional.Absent,
    postAuthenticationLoginBanner: Optional[PostAuthenticationLoginBanner] =
      Optional.Absent,
    preAuthenticationLoginBanner: Optional[PreAuthenticationLoginBanner] =
      Optional.Absent,
    protocols: Optional[Iterable[zio.aws.transfer.model.Protocol]] =
      Optional.Absent,
    protocolDetails: Optional[zio.aws.transfer.model.ProtocolDetails] =
      Optional.Absent,
    securityPolicyName: Optional[SecurityPolicyName] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.transfer.model.Tag]] = Optional.Absent,
    workflowDetails: Optional[zio.aws.transfer.model.WorkflowDetails] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.CreateServerRequest = {
    import CreateServerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.CreateServerRequest
      .builder()
      .optionallyWith(
        certificate.map(value => Certificate.unwrap(value): java.lang.String)
      )(_.certificate)
      .optionallyWith(domain.map(value => value.unwrap))(_.domain)
      .optionallyWith(endpointDetails.map(value => value.buildAwsValue()))(
        _.endpointDetails
      )
      .optionallyWith(endpointType.map(value => value.unwrap))(_.endpointType)
      .optionallyWith(
        hostKey.map(value => HostKey.unwrap(value): java.lang.String)
      )(_.hostKey)
      .optionallyWith(
        identityProviderDetails.map(value => value.buildAwsValue())
      )(_.identityProviderDetails)
      .optionallyWith(identityProviderType.map(value => value.unwrap))(
        _.identityProviderType
      )
      .optionallyWith(
        loggingRole.map(value => Role.unwrap(value): java.lang.String)
      )(_.loggingRole)
      .optionallyWith(
        postAuthenticationLoginBanner.map(value =>
          PostAuthenticationLoginBanner.unwrap(value): java.lang.String
        )
      )(_.postAuthenticationLoginBanner)
      .optionallyWith(
        preAuthenticationLoginBanner.map(value =>
          PreAuthenticationLoginBanner.unwrap(value): java.lang.String
        )
      )(_.preAuthenticationLoginBanner)
      .optionallyWith(
        protocols.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.protocolsWithStrings)
      .optionallyWith(protocolDetails.map(value => value.buildAwsValue()))(
        _.protocolDetails
      )
      .optionallyWith(
        securityPolicyName.map(value =>
          SecurityPolicyName.unwrap(value): java.lang.String
        )
      )(_.securityPolicyName)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(workflowDetails.map(value => value.buildAwsValue()))(
        _.workflowDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.CreateServerRequest.ReadOnly =
    zio.aws.transfer.model.CreateServerRequest.wrap(buildAwsValue())
}
object CreateServerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.CreateServerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.CreateServerRequest =
      zio.aws.transfer.model.CreateServerRequest(
        certificate.map(value => value),
        domain.map(value => value),
        endpointDetails.map(value => value.asEditable),
        endpointType.map(value => value),
        hostKey.map(value => value),
        identityProviderDetails.map(value => value.asEditable),
        identityProviderType.map(value => value),
        loggingRole.map(value => value),
        postAuthenticationLoginBanner.map(value => value),
        preAuthenticationLoginBanner.map(value => value),
        protocols.map(value => value),
        protocolDetails.map(value => value.asEditable),
        securityPolicyName.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        workflowDetails.map(value => value.asEditable)
      )
    def certificate: Optional[Certificate]
    def domain: Optional[zio.aws.transfer.model.Domain]
    def endpointDetails
        : Optional[zio.aws.transfer.model.EndpointDetails.ReadOnly]
    def endpointType: Optional[zio.aws.transfer.model.EndpointType]
    def hostKey: Optional[HostKey]
    def identityProviderDetails
        : Optional[zio.aws.transfer.model.IdentityProviderDetails.ReadOnly]
    def identityProviderType
        : Optional[zio.aws.transfer.model.IdentityProviderType]
    def loggingRole: Optional[Role]
    def postAuthenticationLoginBanner: Optional[PostAuthenticationLoginBanner]
    def preAuthenticationLoginBanner: Optional[PreAuthenticationLoginBanner]
    def protocols: Optional[List[zio.aws.transfer.model.Protocol]]
    def protocolDetails
        : Optional[zio.aws.transfer.model.ProtocolDetails.ReadOnly]
    def securityPolicyName: Optional[SecurityPolicyName]
    def tags: Optional[List[zio.aws.transfer.model.Tag.ReadOnly]]
    def workflowDetails
        : Optional[zio.aws.transfer.model.WorkflowDetails.ReadOnly]
    def getCertificate: ZIO[Any, AwsError, Certificate] =
      AwsError.unwrapOptionField("certificate", certificate)
    def getDomain: ZIO[Any, AwsError, zio.aws.transfer.model.Domain] =
      AwsError.unwrapOptionField("domain", domain)
    def getEndpointDetails
        : ZIO[Any, AwsError, zio.aws.transfer.model.EndpointDetails.ReadOnly] =
      AwsError.unwrapOptionField("endpointDetails", endpointDetails)
    def getEndpointType
        : ZIO[Any, AwsError, zio.aws.transfer.model.EndpointType] =
      AwsError.unwrapOptionField("endpointType", endpointType)
    def getHostKey: ZIO[Any, AwsError, HostKey] =
      AwsError.unwrapOptionField("hostKey", hostKey)
    def getIdentityProviderDetails: ZIO[
      Any,
      AwsError,
      zio.aws.transfer.model.IdentityProviderDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "identityProviderDetails",
      identityProviderDetails
    )
    def getIdentityProviderType
        : ZIO[Any, AwsError, zio.aws.transfer.model.IdentityProviderType] =
      AwsError.unwrapOptionField("identityProviderType", identityProviderType)
    def getLoggingRole: ZIO[Any, AwsError, Role] =
      AwsError.unwrapOptionField("loggingRole", loggingRole)
    def getPostAuthenticationLoginBanner
        : ZIO[Any, AwsError, PostAuthenticationLoginBanner] =
      AwsError.unwrapOptionField(
        "postAuthenticationLoginBanner",
        postAuthenticationLoginBanner
      )
    def getPreAuthenticationLoginBanner
        : ZIO[Any, AwsError, PreAuthenticationLoginBanner] =
      AwsError.unwrapOptionField(
        "preAuthenticationLoginBanner",
        preAuthenticationLoginBanner
      )
    def getProtocols
        : ZIO[Any, AwsError, List[zio.aws.transfer.model.Protocol]] =
      AwsError.unwrapOptionField("protocols", protocols)
    def getProtocolDetails
        : ZIO[Any, AwsError, zio.aws.transfer.model.ProtocolDetails.ReadOnly] =
      AwsError.unwrapOptionField("protocolDetails", protocolDetails)
    def getSecurityPolicyName: ZIO[Any, AwsError, SecurityPolicyName] =
      AwsError.unwrapOptionField("securityPolicyName", securityPolicyName)
    def getTags: ZIO[Any, AwsError, List[zio.aws.transfer.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getWorkflowDetails
        : ZIO[Any, AwsError, zio.aws.transfer.model.WorkflowDetails.ReadOnly] =
      AwsError.unwrapOptionField("workflowDetails", workflowDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.CreateServerRequest
  ) extends zio.aws.transfer.model.CreateServerRequest.ReadOnly {
    override val certificate: Optional[Certificate] = zio.aws.core.internal
      .optionalFromNullable(impl.certificate())
      .map(value => zio.aws.transfer.model.primitives.Certificate(value))
    override val domain: Optional[zio.aws.transfer.model.Domain] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domain())
        .map(value => zio.aws.transfer.model.Domain.wrap(value))
    override val endpointDetails
        : Optional[zio.aws.transfer.model.EndpointDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpointDetails())
        .map(value => zio.aws.transfer.model.EndpointDetails.wrap(value))
    override val endpointType: Optional[zio.aws.transfer.model.EndpointType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpointType())
        .map(value => zio.aws.transfer.model.EndpointType.wrap(value))
    override val hostKey: Optional[HostKey] = zio.aws.core.internal
      .optionalFromNullable(impl.hostKey())
      .map(value => zio.aws.transfer.model.primitives.HostKey(value))
    override val identityProviderDetails
        : Optional[zio.aws.transfer.model.IdentityProviderDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityProviderDetails())
        .map(value =>
          zio.aws.transfer.model.IdentityProviderDetails.wrap(value)
        )
    override val identityProviderType
        : Optional[zio.aws.transfer.model.IdentityProviderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityProviderType())
        .map(value => zio.aws.transfer.model.IdentityProviderType.wrap(value))
    override val loggingRole: Optional[Role] = zio.aws.core.internal
      .optionalFromNullable(impl.loggingRole())
      .map(value => zio.aws.transfer.model.primitives.Role(value))
    override val postAuthenticationLoginBanner
        : Optional[PostAuthenticationLoginBanner] = zio.aws.core.internal
      .optionalFromNullable(impl.postAuthenticationLoginBanner())
      .map(value =>
        zio.aws.transfer.model.primitives.PostAuthenticationLoginBanner(value)
      )
    override val preAuthenticationLoginBanner
        : Optional[PreAuthenticationLoginBanner] = zio.aws.core.internal
      .optionalFromNullable(impl.preAuthenticationLoginBanner())
      .map(value =>
        zio.aws.transfer.model.primitives.PreAuthenticationLoginBanner(value)
      )
    override val protocols: Optional[List[zio.aws.transfer.model.Protocol]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocols())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transfer.model.Protocol.wrap(item)
          }.toList
        )
    override val protocolDetails
        : Optional[zio.aws.transfer.model.ProtocolDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocolDetails())
        .map(value => zio.aws.transfer.model.ProtocolDetails.wrap(value))
    override val securityPolicyName: Optional[SecurityPolicyName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityPolicyName())
        .map(value =>
          zio.aws.transfer.model.primitives.SecurityPolicyName(value)
        )
    override val tags: Optional[List[zio.aws.transfer.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transfer.model.Tag.wrap(item)
          }.toList
        )
    override val workflowDetails
        : Optional[zio.aws.transfer.model.WorkflowDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workflowDetails())
        .map(value => zio.aws.transfer.model.WorkflowDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.CreateServerRequest
  ): zio.aws.transfer.model.CreateServerRequest.ReadOnly = new Wrapper(impl)
}
