package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.WorkflowId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateWorkflowResponse(workflowId: WorkflowId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.CreateWorkflowResponse = {
    import CreateWorkflowResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.CreateWorkflowResponse
      .builder()
      .workflowId(WorkflowId.unwrap(workflowId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.CreateWorkflowResponse.ReadOnly =
    zio.aws.transfer.model.CreateWorkflowResponse.wrap(buildAwsValue())
}
object CreateWorkflowResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.CreateWorkflowResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.CreateWorkflowResponse =
      zio.aws.transfer.model.CreateWorkflowResponse(workflowId)
    def workflowId: WorkflowId
    def getWorkflowId: ZIO[Any, Nothing, WorkflowId] = ZIO.succeed(workflowId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.CreateWorkflowResponse
  ) extends zio.aws.transfer.model.CreateWorkflowResponse.ReadOnly {
    override val workflowId: WorkflowId =
      zio.aws.transfer.model.primitives.WorkflowId(impl.workflowId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.CreateWorkflowResponse
  ): zio.aws.transfer.model.CreateWorkflowResponse.ReadOnly = new Wrapper(impl)
}
