package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{ExternalId, ServerId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteAccessRequest(
    serverId: ServerId,
    externalId: ExternalId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.DeleteAccessRequest = {
    import DeleteAccessRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.DeleteAccessRequest
      .builder()
      .serverId(ServerId.unwrap(serverId): java.lang.String)
      .externalId(ExternalId.unwrap(externalId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.DeleteAccessRequest.ReadOnly =
    zio.aws.transfer.model.DeleteAccessRequest.wrap(buildAwsValue())
}
object DeleteAccessRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.DeleteAccessRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.DeleteAccessRequest =
      zio.aws.transfer.model.DeleteAccessRequest(serverId, externalId)
    def serverId: ServerId
    def externalId: ExternalId
    def getServerId: ZIO[Any, Nothing, ServerId] = ZIO.succeed(serverId)
    def getExternalId: ZIO[Any, Nothing, ExternalId] = ZIO.succeed(externalId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.DeleteAccessRequest
  ) extends zio.aws.transfer.model.DeleteAccessRequest.ReadOnly {
    override val serverId: ServerId =
      zio.aws.transfer.model.primitives.ServerId(impl.serverId())
    override val externalId: ExternalId =
      zio.aws.transfer.model.primitives.ExternalId(impl.externalId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.DeleteAccessRequest
  ): zio.aws.transfer.model.DeleteAccessRequest.ReadOnly = new Wrapper(impl)
}
