package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.WorkflowId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteWorkflowRequest(workflowId: WorkflowId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.DeleteWorkflowRequest = {
    import DeleteWorkflowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.DeleteWorkflowRequest
      .builder()
      .workflowId(WorkflowId.unwrap(workflowId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.DeleteWorkflowRequest.ReadOnly =
    zio.aws.transfer.model.DeleteWorkflowRequest.wrap(buildAwsValue())
}
object DeleteWorkflowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.DeleteWorkflowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.DeleteWorkflowRequest =
      zio.aws.transfer.model.DeleteWorkflowRequest(workflowId)
    def workflowId: WorkflowId
    def getWorkflowId: ZIO[Any, Nothing, WorkflowId] = ZIO.succeed(workflowId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.DeleteWorkflowRequest
  ) extends zio.aws.transfer.model.DeleteWorkflowRequest.ReadOnly {
    override val workflowId: WorkflowId =
      zio.aws.transfer.model.primitives.WorkflowId(impl.workflowId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.DeleteWorkflowRequest
  ): zio.aws.transfer.model.DeleteWorkflowRequest.ReadOnly = new Wrapper(impl)
}
