package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.ServerId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeAccessResponse(
    serverId: ServerId,
    access: zio.aws.transfer.model.DescribedAccess
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.DescribeAccessResponse = {
    import DescribeAccessResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.DescribeAccessResponse
      .builder()
      .serverId(ServerId.unwrap(serverId): java.lang.String)
      .access(access.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.DescribeAccessResponse.ReadOnly =
    zio.aws.transfer.model.DescribeAccessResponse.wrap(buildAwsValue())
}
object DescribeAccessResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.DescribeAccessResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.DescribeAccessResponse =
      zio.aws.transfer.model.DescribeAccessResponse(serverId, access.asEditable)
    def serverId: ServerId
    def access: zio.aws.transfer.model.DescribedAccess.ReadOnly
    def getServerId: ZIO[Any, Nothing, ServerId] = ZIO.succeed(serverId)
    def getAccess
        : ZIO[Any, Nothing, zio.aws.transfer.model.DescribedAccess.ReadOnly] =
      ZIO.succeed(access)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.DescribeAccessResponse
  ) extends zio.aws.transfer.model.DescribeAccessResponse.ReadOnly {
    override val serverId: ServerId =
      zio.aws.transfer.model.primitives.ServerId(impl.serverId())
    override val access: zio.aws.transfer.model.DescribedAccess.ReadOnly =
      zio.aws.transfer.model.DescribedAccess.wrap(impl.access())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.DescribeAccessResponse
  ): zio.aws.transfer.model.DescribeAccessResponse.ReadOnly = new Wrapper(impl)
}
