package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.ServerId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeServerRequest(serverId: ServerId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.DescribeServerRequest = {
    import DescribeServerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.DescribeServerRequest
      .builder()
      .serverId(ServerId.unwrap(serverId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.DescribeServerRequest.ReadOnly =
    zio.aws.transfer.model.DescribeServerRequest.wrap(buildAwsValue())
}
object DescribeServerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.DescribeServerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.DescribeServerRequest =
      zio.aws.transfer.model.DescribeServerRequest(serverId)
    def serverId: ServerId
    def getServerId: ZIO[Any, Nothing, ServerId] = ZIO.succeed(serverId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.DescribeServerRequest
  ) extends zio.aws.transfer.model.DescribeServerRequest.ReadOnly {
    override val serverId: ServerId =
      zio.aws.transfer.model.primitives.ServerId(impl.serverId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.DescribeServerRequest
  ): zio.aws.transfer.model.DescribeServerRequest.ReadOnly = new Wrapper(impl)
}
