package zio.aws.transfer.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeServerResponse(
    server: zio.aws.transfer.model.DescribedServer
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.DescribeServerResponse = {
    import DescribeServerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.DescribeServerResponse
      .builder()
      .server(server.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.DescribeServerResponse.ReadOnly =
    zio.aws.transfer.model.DescribeServerResponse.wrap(buildAwsValue())
}
object DescribeServerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.DescribeServerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.DescribeServerResponse =
      zio.aws.transfer.model.DescribeServerResponse(server.asEditable)
    def server: zio.aws.transfer.model.DescribedServer.ReadOnly
    def getServer
        : ZIO[Any, Nothing, zio.aws.transfer.model.DescribedServer.ReadOnly] =
      ZIO.succeed(server)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.DescribeServerResponse
  ) extends zio.aws.transfer.model.DescribeServerResponse.ReadOnly {
    override val server: zio.aws.transfer.model.DescribedServer.ReadOnly =
      zio.aws.transfer.model.DescribedServer.wrap(impl.server())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.DescribeServerResponse
  ): zio.aws.transfer.model.DescribeServerResponse.ReadOnly = new Wrapper(impl)
}
