package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{Role, ExecutionId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribedExecution(
    executionId: Optional[ExecutionId] = Optional.Absent,
    initialFileLocation: Optional[zio.aws.transfer.model.FileLocation] =
      Optional.Absent,
    serviceMetadata: Optional[zio.aws.transfer.model.ServiceMetadata] =
      Optional.Absent,
    executionRole: Optional[Role] = Optional.Absent,
    loggingConfiguration: Optional[
      zio.aws.transfer.model.LoggingConfiguration
    ] = Optional.Absent,
    posixProfile: Optional[zio.aws.transfer.model.PosixProfile] =
      Optional.Absent,
    status: Optional[zio.aws.transfer.model.ExecutionStatus] = Optional.Absent,
    results: Optional[zio.aws.transfer.model.ExecutionResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.DescribedExecution = {
    import DescribedExecution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.DescribedExecution
      .builder()
      .optionallyWith(
        executionId.map(value => ExecutionId.unwrap(value): java.lang.String)
      )(_.executionId)
      .optionallyWith(initialFileLocation.map(value => value.buildAwsValue()))(
        _.initialFileLocation
      )
      .optionallyWith(serviceMetadata.map(value => value.buildAwsValue()))(
        _.serviceMetadata
      )
      .optionallyWith(
        executionRole.map(value => Role.unwrap(value): java.lang.String)
      )(_.executionRole)
      .optionallyWith(loggingConfiguration.map(value => value.buildAwsValue()))(
        _.loggingConfiguration
      )
      .optionallyWith(posixProfile.map(value => value.buildAwsValue()))(
        _.posixProfile
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(results.map(value => value.buildAwsValue()))(_.results)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.DescribedExecution.ReadOnly =
    zio.aws.transfer.model.DescribedExecution.wrap(buildAwsValue())
}
object DescribedExecution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.DescribedExecution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.DescribedExecution =
      zio.aws.transfer.model.DescribedExecution(
        executionId.map(value => value),
        initialFileLocation.map(value => value.asEditable),
        serviceMetadata.map(value => value.asEditable),
        executionRole.map(value => value),
        loggingConfiguration.map(value => value.asEditable),
        posixProfile.map(value => value.asEditable),
        status.map(value => value),
        results.map(value => value.asEditable)
      )
    def executionId: Optional[ExecutionId]
    def initialFileLocation
        : Optional[zio.aws.transfer.model.FileLocation.ReadOnly]
    def serviceMetadata
        : Optional[zio.aws.transfer.model.ServiceMetadata.ReadOnly]
    def executionRole: Optional[Role]
    def loggingConfiguration
        : Optional[zio.aws.transfer.model.LoggingConfiguration.ReadOnly]
    def posixProfile: Optional[zio.aws.transfer.model.PosixProfile.ReadOnly]
    def status: Optional[zio.aws.transfer.model.ExecutionStatus]
    def results: Optional[zio.aws.transfer.model.ExecutionResults.ReadOnly]
    def getExecutionId: ZIO[Any, AwsError, ExecutionId] =
      AwsError.unwrapOptionField("executionId", executionId)
    def getInitialFileLocation
        : ZIO[Any, AwsError, zio.aws.transfer.model.FileLocation.ReadOnly] =
      AwsError.unwrapOptionField("initialFileLocation", initialFileLocation)
    def getServiceMetadata
        : ZIO[Any, AwsError, zio.aws.transfer.model.ServiceMetadata.ReadOnly] =
      AwsError.unwrapOptionField("serviceMetadata", serviceMetadata)
    def getExecutionRole: ZIO[Any, AwsError, Role] =
      AwsError.unwrapOptionField("executionRole", executionRole)
    def getLoggingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.transfer.model.LoggingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("loggingConfiguration", loggingConfiguration)
    def getPosixProfile
        : ZIO[Any, AwsError, zio.aws.transfer.model.PosixProfile.ReadOnly] =
      AwsError.unwrapOptionField("posixProfile", posixProfile)
    def getStatus: ZIO[Any, AwsError, zio.aws.transfer.model.ExecutionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getResults
        : ZIO[Any, AwsError, zio.aws.transfer.model.ExecutionResults.ReadOnly] =
      AwsError.unwrapOptionField("results", results)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.DescribedExecution
  ) extends zio.aws.transfer.model.DescribedExecution.ReadOnly {
    override val executionId: Optional[ExecutionId] = zio.aws.core.internal
      .optionalFromNullable(impl.executionId())
      .map(value => zio.aws.transfer.model.primitives.ExecutionId(value))
    override val initialFileLocation
        : Optional[zio.aws.transfer.model.FileLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.initialFileLocation())
        .map(value => zio.aws.transfer.model.FileLocation.wrap(value))
    override val serviceMetadata
        : Optional[zio.aws.transfer.model.ServiceMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceMetadata())
        .map(value => zio.aws.transfer.model.ServiceMetadata.wrap(value))
    override val executionRole: Optional[Role] = zio.aws.core.internal
      .optionalFromNullable(impl.executionRole())
      .map(value => zio.aws.transfer.model.primitives.Role(value))
    override val loggingConfiguration
        : Optional[zio.aws.transfer.model.LoggingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loggingConfiguration())
        .map(value => zio.aws.transfer.model.LoggingConfiguration.wrap(value))
    override val posixProfile
        : Optional[zio.aws.transfer.model.PosixProfile.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.posixProfile())
        .map(value => zio.aws.transfer.model.PosixProfile.wrap(value))
    override val status: Optional[zio.aws.transfer.model.ExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.transfer.model.ExecutionStatus.wrap(value))
    override val results
        : Optional[zio.aws.transfer.model.ExecutionResults.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.results())
        .map(value => zio.aws.transfer.model.ExecutionResults.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.DescribedExecution
  ): zio.aws.transfer.model.DescribedExecution.ReadOnly = new Wrapper(impl)
}
