package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.StepResultOutputsJson
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ExecutionStepResult(
    stepType: Optional[zio.aws.transfer.model.WorkflowStepType] =
      Optional.Absent,
    outputs: Optional[StepResultOutputsJson] = Optional.Absent,
    error: Optional[zio.aws.transfer.model.ExecutionError] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.ExecutionStepResult = {
    import ExecutionStepResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.ExecutionStepResult
      .builder()
      .optionallyWith(stepType.map(value => value.unwrap))(_.stepType)
      .optionallyWith(
        outputs.map(value =>
          StepResultOutputsJson.unwrap(value): java.lang.String
        )
      )(_.outputs)
      .optionallyWith(error.map(value => value.buildAwsValue()))(_.error)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.ExecutionStepResult.ReadOnly =
    zio.aws.transfer.model.ExecutionStepResult.wrap(buildAwsValue())
}
object ExecutionStepResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.ExecutionStepResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.ExecutionStepResult =
      zio.aws.transfer.model.ExecutionStepResult(
        stepType.map(value => value),
        outputs.map(value => value),
        error.map(value => value.asEditable)
      )
    def stepType: Optional[zio.aws.transfer.model.WorkflowStepType]
    def outputs: Optional[StepResultOutputsJson]
    def error: Optional[zio.aws.transfer.model.ExecutionError.ReadOnly]
    def getStepType
        : ZIO[Any, AwsError, zio.aws.transfer.model.WorkflowStepType] =
      AwsError.unwrapOptionField("stepType", stepType)
    def getOutputs: ZIO[Any, AwsError, StepResultOutputsJson] =
      AwsError.unwrapOptionField("outputs", outputs)
    def getError
        : ZIO[Any, AwsError, zio.aws.transfer.model.ExecutionError.ReadOnly] =
      AwsError.unwrapOptionField("error", error)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.ExecutionStepResult
  ) extends zio.aws.transfer.model.ExecutionStepResult.ReadOnly {
    override val stepType: Optional[zio.aws.transfer.model.WorkflowStepType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stepType())
        .map(value => zio.aws.transfer.model.WorkflowStepType.wrap(value))
    override val outputs: Optional[StepResultOutputsJson] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputs())
        .map(value =>
          zio.aws.transfer.model.primitives.StepResultOutputsJson(value)
        )
    override val error
        : Optional[zio.aws.transfer.model.ExecutionError.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.error())
        .map(value => zio.aws.transfer.model.ExecutionError.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.ExecutionStepResult
  ): zio.aws.transfer.model.ExecutionStepResult.ReadOnly = new Wrapper(impl)
}
