package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{MapTarget, MapEntry}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class HomeDirectoryMapEntry(entry: MapEntry, target: MapTarget) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.HomeDirectoryMapEntry = {
    import HomeDirectoryMapEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.HomeDirectoryMapEntry
      .builder()
      .entry(MapEntry.unwrap(entry): java.lang.String)
      .target(MapTarget.unwrap(target): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.HomeDirectoryMapEntry.ReadOnly =
    zio.aws.transfer.model.HomeDirectoryMapEntry.wrap(buildAwsValue())
}
object HomeDirectoryMapEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.HomeDirectoryMapEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.HomeDirectoryMapEntry =
      zio.aws.transfer.model.HomeDirectoryMapEntry(entry, target)
    def entry: MapEntry
    def target: MapTarget
    def getEntry: ZIO[Any, Nothing, MapEntry] = ZIO.succeed(entry)
    def getTarget: ZIO[Any, Nothing, MapTarget] = ZIO.succeed(target)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.HomeDirectoryMapEntry
  ) extends zio.aws.transfer.model.HomeDirectoryMapEntry.ReadOnly {
    override val entry: MapEntry =
      zio.aws.transfer.model.primitives.MapEntry(impl.entry())
    override val target: MapTarget =
      zio.aws.transfer.model.primitives.MapTarget(impl.target())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.HomeDirectoryMapEntry
  ): zio.aws.transfer.model.HomeDirectoryMapEntry.ReadOnly = new Wrapper(impl)
}
