package zio.aws.transfer.model
import scala.jdk.CollectionConverters._
sealed trait HomeDirectoryType {
  def unwrap: software.amazon.awssdk.services.transfer.model.HomeDirectoryType
}
object HomeDirectoryType {
  def wrap(
      value: software.amazon.awssdk.services.transfer.model.HomeDirectoryType
  ): zio.aws.transfer.model.HomeDirectoryType = value match {
    case software.amazon.awssdk.services.transfer.model.HomeDirectoryType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transfer.model.HomeDirectoryType.PATH =>
      val r = PATH
      r
    case software.amazon.awssdk.services.transfer.model.HomeDirectoryType.LOGICAL =>
      val r = LOGICAL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.transfer.model.HomeDirectoryType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.HomeDirectoryType =
      software.amazon.awssdk.services.transfer.model.HomeDirectoryType.UNKNOWN_TO_SDK_VERSION
  }
  case object PATH extends zio.aws.transfer.model.HomeDirectoryType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.HomeDirectoryType =
      software.amazon.awssdk.services.transfer.model.HomeDirectoryType.PATH
  }
  case object LOGICAL extends zio.aws.transfer.model.HomeDirectoryType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.HomeDirectoryType =
      software.amazon.awssdk.services.transfer.model.HomeDirectoryType.LOGICAL
  }
}
