package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{UserName, SshPublicKeyBody, ServerId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ImportSshPublicKeyRequest(
    serverId: ServerId,
    sshPublicKeyBody: SshPublicKeyBody,
    userName: UserName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.ImportSshPublicKeyRequest = {
    import ImportSshPublicKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.ImportSshPublicKeyRequest
      .builder()
      .serverId(ServerId.unwrap(serverId): java.lang.String)
      .sshPublicKeyBody(
        SshPublicKeyBody.unwrap(sshPublicKeyBody): java.lang.String
      )
      .userName(UserName.unwrap(userName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.ImportSshPublicKeyRequest.ReadOnly =
    zio.aws.transfer.model.ImportSshPublicKeyRequest.wrap(buildAwsValue())
}
object ImportSshPublicKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.ImportSshPublicKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.ImportSshPublicKeyRequest =
      zio.aws.transfer.model
        .ImportSshPublicKeyRequest(serverId, sshPublicKeyBody, userName)
    def serverId: ServerId
    def sshPublicKeyBody: SshPublicKeyBody
    def userName: UserName
    def getServerId: ZIO[Any, Nothing, ServerId] = ZIO.succeed(serverId)
    def getSshPublicKeyBody: ZIO[Any, Nothing, SshPublicKeyBody] =
      ZIO.succeed(sshPublicKeyBody)
    def getUserName: ZIO[Any, Nothing, UserName] = ZIO.succeed(userName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.ImportSshPublicKeyRequest
  ) extends zio.aws.transfer.model.ImportSshPublicKeyRequest.ReadOnly {
    override val serverId: ServerId =
      zio.aws.transfer.model.primitives.ServerId(impl.serverId())
    override val sshPublicKeyBody: SshPublicKeyBody =
      zio.aws.transfer.model.primitives
        .SshPublicKeyBody(impl.sshPublicKeyBody())
    override val userName: UserName =
      zio.aws.transfer.model.primitives.UserName(impl.userName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.ImportSshPublicKeyRequest
  ): zio.aws.transfer.model.ImportSshPublicKeyRequest.ReadOnly = new Wrapper(
    impl
  )
}
