package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{SecurityPolicyName, NextToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListSecurityPoliciesResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    securityPolicyNames: Iterable[SecurityPolicyName]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.ListSecurityPoliciesResponse = {
    import ListSecurityPoliciesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.ListSecurityPoliciesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .securityPolicyNames(securityPolicyNames.map { item =>
        SecurityPolicyName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.ListSecurityPoliciesResponse.ReadOnly =
    zio.aws.transfer.model.ListSecurityPoliciesResponse.wrap(buildAwsValue())
}
object ListSecurityPoliciesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.ListSecurityPoliciesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.ListSecurityPoliciesResponse =
      zio.aws.transfer.model.ListSecurityPoliciesResponse(
        nextToken.map(value => value),
        securityPolicyNames
      )
    def nextToken: Optional[NextToken]
    def securityPolicyNames: List[SecurityPolicyName]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSecurityPolicyNames: ZIO[Any, Nothing, List[SecurityPolicyName]] =
      ZIO.succeed(securityPolicyNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.ListSecurityPoliciesResponse
  ) extends zio.aws.transfer.model.ListSecurityPoliciesResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.transfer.model.primitives.NextToken(value))
    override val securityPolicyNames: List[SecurityPolicyName] = impl
      .securityPolicyNames()
      .asScala
      .map { item =>
        zio.aws.transfer.model.primitives.SecurityPolicyName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.ListSecurityPoliciesResponse
  ): zio.aws.transfer.model.ListSecurityPoliciesResponse.ReadOnly = new Wrapper(
    impl
  )
}
