package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListServersResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    servers: Iterable[zio.aws.transfer.model.ListedServer]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.ListServersResponse = {
    import ListServersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.ListServersResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .servers(servers.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.ListServersResponse.ReadOnly =
    zio.aws.transfer.model.ListServersResponse.wrap(buildAwsValue())
}
object ListServersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.ListServersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.ListServersResponse =
      zio.aws.transfer.model.ListServersResponse(
        nextToken.map(value => value),
        servers.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[NextToken]
    def servers: List[zio.aws.transfer.model.ListedServer.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getServers: ZIO[Any, Nothing, List[
      zio.aws.transfer.model.ListedServer.ReadOnly
    ]] = ZIO.succeed(servers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.ListServersResponse
  ) extends zio.aws.transfer.model.ListServersResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.transfer.model.primitives.NextToken(value))
    override val servers: List[zio.aws.transfer.model.ListedServer.ReadOnly] =
      impl
        .servers()
        .asScala
        .map { item =>
          zio.aws.transfer.model.ListedServer.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.ListServersResponse
  ): zio.aws.transfer.model.ListServersResponse.ReadOnly = new Wrapper(impl)
}
