package zio.aws.transfer.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.transfer.model.primitives.{UserCount, ServerId, Role, Arn}
import scala.jdk.CollectionConverters._
final case class ListedServer(
    arn: Arn,
    domain: Optional[zio.aws.transfer.model.Domain] = Optional.Absent,
    identityProviderType: Optional[
      zio.aws.transfer.model.IdentityProviderType
    ] = Optional.Absent,
    endpointType: Optional[zio.aws.transfer.model.EndpointType] =
      Optional.Absent,
    loggingRole: Optional[Role] = Optional.Absent,
    serverId: Optional[ServerId] = Optional.Absent,
    state: Optional[zio.aws.transfer.model.State] = Optional.Absent,
    userCount: Optional[UserCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.ListedServer = {
    import ListedServer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.ListedServer
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .optionallyWith(domain.map(value => value.unwrap))(_.domain)
      .optionallyWith(identityProviderType.map(value => value.unwrap))(
        _.identityProviderType
      )
      .optionallyWith(endpointType.map(value => value.unwrap))(_.endpointType)
      .optionallyWith(
        loggingRole.map(value => Role.unwrap(value): java.lang.String)
      )(_.loggingRole)
      .optionallyWith(
        serverId.map(value => ServerId.unwrap(value): java.lang.String)
      )(_.serverId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(userCount.map(value => UserCount.unwrap(value): Integer))(
        _.userCount
      )
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.ListedServer.ReadOnly =
    zio.aws.transfer.model.ListedServer.wrap(buildAwsValue())
}
object ListedServer {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.ListedServer
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.ListedServer =
      zio.aws.transfer.model.ListedServer(
        arn,
        domain.map(value => value),
        identityProviderType.map(value => value),
        endpointType.map(value => value),
        loggingRole.map(value => value),
        serverId.map(value => value),
        state.map(value => value),
        userCount.map(value => value)
      )
    def arn: Arn
    def domain: Optional[zio.aws.transfer.model.Domain]
    def identityProviderType
        : Optional[zio.aws.transfer.model.IdentityProviderType]
    def endpointType: Optional[zio.aws.transfer.model.EndpointType]
    def loggingRole: Optional[Role]
    def serverId: Optional[ServerId]
    def state: Optional[zio.aws.transfer.model.State]
    def userCount: Optional[UserCount]
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getDomain: ZIO[Any, AwsError, zio.aws.transfer.model.Domain] =
      AwsError.unwrapOptionField("domain", domain)
    def getIdentityProviderType
        : ZIO[Any, AwsError, zio.aws.transfer.model.IdentityProviderType] =
      AwsError.unwrapOptionField("identityProviderType", identityProviderType)
    def getEndpointType
        : ZIO[Any, AwsError, zio.aws.transfer.model.EndpointType] =
      AwsError.unwrapOptionField("endpointType", endpointType)
    def getLoggingRole: ZIO[Any, AwsError, Role] =
      AwsError.unwrapOptionField("loggingRole", loggingRole)
    def getServerId: ZIO[Any, AwsError, ServerId] =
      AwsError.unwrapOptionField("serverId", serverId)
    def getState: ZIO[Any, AwsError, zio.aws.transfer.model.State] =
      AwsError.unwrapOptionField("state", state)
    def getUserCount: ZIO[Any, AwsError, UserCount] =
      AwsError.unwrapOptionField("userCount", userCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.ListedServer
  ) extends zio.aws.transfer.model.ListedServer.ReadOnly {
    override val arn: Arn = zio.aws.transfer.model.primitives.Arn(impl.arn())
    override val domain: Optional[zio.aws.transfer.model.Domain] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domain())
        .map(value => zio.aws.transfer.model.Domain.wrap(value))
    override val identityProviderType
        : Optional[zio.aws.transfer.model.IdentityProviderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityProviderType())
        .map(value => zio.aws.transfer.model.IdentityProviderType.wrap(value))
    override val endpointType: Optional[zio.aws.transfer.model.EndpointType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpointType())
        .map(value => zio.aws.transfer.model.EndpointType.wrap(value))
    override val loggingRole: Optional[Role] = zio.aws.core.internal
      .optionalFromNullable(impl.loggingRole())
      .map(value => zio.aws.transfer.model.primitives.Role(value))
    override val serverId: Optional[ServerId] = zio.aws.core.internal
      .optionalFromNullable(impl.serverId())
      .map(value => zio.aws.transfer.model.primitives.ServerId(value))
    override val state: Optional[zio.aws.transfer.model.State] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.transfer.model.State.wrap(value))
    override val userCount: Optional[UserCount] = zio.aws.core.internal
      .optionalFromNullable(impl.userCount())
      .map(value => zio.aws.transfer.model.primitives.UserCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.ListedServer
  ): zio.aws.transfer.model.ListedServer.ReadOnly = new Wrapper(impl)
}
