package zio.aws.transfer.model
import scala.jdk.CollectionConverters._
sealed trait OverwriteExisting {
  def unwrap: software.amazon.awssdk.services.transfer.model.OverwriteExisting
}
object OverwriteExisting {
  def wrap(
      value: software.amazon.awssdk.services.transfer.model.OverwriteExisting
  ): zio.aws.transfer.model.OverwriteExisting = value match {
    case software.amazon.awssdk.services.transfer.model.OverwriteExisting.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transfer.model.OverwriteExisting.TRUE =>
      val r = TRUE
      r
    case software.amazon.awssdk.services.transfer.model.OverwriteExisting.FALSE =>
      val r = FALSE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.transfer.model.OverwriteExisting {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.OverwriteExisting =
      software.amazon.awssdk.services.transfer.model.OverwriteExisting.UNKNOWN_TO_SDK_VERSION
  }
  case object TRUE extends zio.aws.transfer.model.OverwriteExisting {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.OverwriteExisting =
      software.amazon.awssdk.services.transfer.model.OverwriteExisting.TRUE
  }
  case object FALSE extends zio.aws.transfer.model.OverwriteExisting {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.OverwriteExisting =
      software.amazon.awssdk.services.transfer.model.OverwriteExisting.FALSE
  }
}
