package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.PosixId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PosixProfile(
    uid: PosixId,
    gid: PosixId,
    secondaryGids: Optional[Iterable[PosixId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.PosixProfile = {
    import PosixProfile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.PosixProfile
      .builder()
      .uid(PosixId.unwrap(uid): java.lang.Long)
      .gid(PosixId.unwrap(gid): java.lang.Long)
      .optionallyWith(
        secondaryGids.map(value =>
          value.map { item =>
            PosixId.unwrap(item): java.lang.Long
          }.asJavaCollection
        )
      )(_.secondaryGids)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.PosixProfile.ReadOnly =
    zio.aws.transfer.model.PosixProfile.wrap(buildAwsValue())
}
object PosixProfile {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.PosixProfile
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.PosixProfile = zio.aws.transfer.model
      .PosixProfile(uid, gid, secondaryGids.map(value => value))
    def uid: PosixId
    def gid: PosixId
    def secondaryGids: Optional[List[PosixId]]
    def getUid: ZIO[Any, Nothing, PosixId] = ZIO.succeed(uid)
    def getGid: ZIO[Any, Nothing, PosixId] = ZIO.succeed(gid)
    def getSecondaryGids: ZIO[Any, AwsError, List[PosixId]] =
      AwsError.unwrapOptionField("secondaryGids", secondaryGids)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.PosixProfile
  ) extends zio.aws.transfer.model.PosixProfile.ReadOnly {
    override val uid: PosixId =
      zio.aws.transfer.model.primitives.PosixId(impl.uid())
    override val gid: PosixId =
      zio.aws.transfer.model.primitives.PosixId(impl.gid())
    override val secondaryGids: Optional[List[PosixId]] = zio.aws.core.internal
      .optionalFromNullable(impl.secondaryGids())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transfer.model.primitives.PosixId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.PosixProfile
  ): zio.aws.transfer.model.PosixProfile.ReadOnly = new Wrapper(impl)
}
