package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{S3TagValue, S3TagKey}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class S3Tag(key: S3TagKey, value: S3TagValue) {
  def buildAwsValue(): software.amazon.awssdk.services.transfer.model.S3Tag = {
    import S3Tag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.S3Tag
      .builder()
      .key(S3TagKey.unwrap(key): java.lang.String)
      .value(S3TagValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.S3Tag.ReadOnly =
    zio.aws.transfer.model.S3Tag.wrap(buildAwsValue())
}
object S3Tag {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.transfer.model.S3Tag] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.S3Tag =
      zio.aws.transfer.model.S3Tag(key, value)
    def key: S3TagKey
    def value: S3TagValue
    def getKey: ZIO[Any, Nothing, S3TagKey] = ZIO.succeed(key)
    def getValue: ZIO[Any, Nothing, S3TagValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.S3Tag
  ) extends zio.aws.transfer.model.S3Tag.ReadOnly {
    override val key: S3TagKey =
      zio.aws.transfer.model.primitives.S3TagKey(impl.key())
    override val value: S3TagValue =
      zio.aws.transfer.model.primitives.S3TagValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.S3Tag
  ): zio.aws.transfer.model.S3Tag.ReadOnly = new Wrapper(impl)
}
