package zio.aws.transfer.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ServiceMetadata(
    userDetails: zio.aws.transfer.model.UserDetails
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.ServiceMetadata = {
    import ServiceMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.ServiceMetadata
      .builder()
      .userDetails(userDetails.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.ServiceMetadata.ReadOnly =
    zio.aws.transfer.model.ServiceMetadata.wrap(buildAwsValue())
}
object ServiceMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.ServiceMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.ServiceMetadata =
      zio.aws.transfer.model.ServiceMetadata(userDetails.asEditable)
    def userDetails: zio.aws.transfer.model.UserDetails.ReadOnly
    def getUserDetails
        : ZIO[Any, Nothing, zio.aws.transfer.model.UserDetails.ReadOnly] =
      ZIO.succeed(userDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.ServiceMetadata
  ) extends zio.aws.transfer.model.ServiceMetadata.ReadOnly {
    override val userDetails: zio.aws.transfer.model.UserDetails.ReadOnly =
      zio.aws.transfer.model.UserDetails.wrap(impl.userDetails())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.ServiceMetadata
  ): zio.aws.transfer.model.ServiceMetadata.ReadOnly = new Wrapper(impl)
}
