package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.ServerId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StartServerRequest(serverId: ServerId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.StartServerRequest = {
    import StartServerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.StartServerRequest
      .builder()
      .serverId(ServerId.unwrap(serverId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.StartServerRequest.ReadOnly =
    zio.aws.transfer.model.StartServerRequest.wrap(buildAwsValue())
}
object StartServerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.StartServerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.StartServerRequest =
      zio.aws.transfer.model.StartServerRequest(serverId)
    def serverId: ServerId
    def getServerId: ZIO[Any, Nothing, ServerId] = ZIO.succeed(serverId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.StartServerRequest
  ) extends zio.aws.transfer.model.StartServerRequest.ReadOnly {
    override val serverId: ServerId =
      zio.aws.transfer.model.primitives.ServerId(impl.serverId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.StartServerRequest
  ): zio.aws.transfer.model.StartServerRequest.ReadOnly = new Wrapper(impl)
}
