package zio.aws.transfer.model
import scala.jdk.CollectionConverters._
sealed trait State {
  def unwrap: software.amazon.awssdk.services.transfer.model.State
}
object State {
  def wrap(
      value: software.amazon.awssdk.services.transfer.model.State
  ): zio.aws.transfer.model.State = value match {
    case software.amazon.awssdk.services.transfer.model.State.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transfer.model.State.OFFLINE =>
      val r = OFFLINE
      r
    case software.amazon.awssdk.services.transfer.model.State.ONLINE =>
      val r = ONLINE
      r
    case software.amazon.awssdk.services.transfer.model.State.STARTING =>
      val r = STARTING
      r
    case software.amazon.awssdk.services.transfer.model.State.STOPPING =>
      val r = STOPPING
      r
    case software.amazon.awssdk.services.transfer.model.State.START_FAILED =>
      val r = START_FAILED
      r
    case software.amazon.awssdk.services.transfer.model.State.STOP_FAILED =>
      val r = STOP_FAILED
      r
  }
  case object unknownToSdkVersion extends zio.aws.transfer.model.State {
    override def unwrap: software.amazon.awssdk.services.transfer.model.State =
      software.amazon.awssdk.services.transfer.model.State.UNKNOWN_TO_SDK_VERSION
  }
  case object OFFLINE extends zio.aws.transfer.model.State {
    override def unwrap: software.amazon.awssdk.services.transfer.model.State =
      software.amazon.awssdk.services.transfer.model.State.OFFLINE
  }
  case object ONLINE extends zio.aws.transfer.model.State {
    override def unwrap: software.amazon.awssdk.services.transfer.model.State =
      software.amazon.awssdk.services.transfer.model.State.ONLINE
  }
  case object STARTING extends zio.aws.transfer.model.State {
    override def unwrap: software.amazon.awssdk.services.transfer.model.State =
      software.amazon.awssdk.services.transfer.model.State.STARTING
  }
  case object STOPPING extends zio.aws.transfer.model.State {
    override def unwrap: software.amazon.awssdk.services.transfer.model.State =
      software.amazon.awssdk.services.transfer.model.State.STOPPING
  }
  case object START_FAILED extends zio.aws.transfer.model.State {
    override def unwrap: software.amazon.awssdk.services.transfer.model.State =
      software.amazon.awssdk.services.transfer.model.State.START_FAILED
  }
  case object STOP_FAILED extends zio.aws.transfer.model.State {
    override def unwrap: software.amazon.awssdk.services.transfer.model.State =
      software.amazon.awssdk.services.transfer.model.State.STOP_FAILED
  }
}
