package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    arn: Arn,
    tags: Iterable[zio.aws.transfer.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.TagResourceRequest
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.TagResourceRequest.ReadOnly =
    zio.aws.transfer.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.TagResourceRequest =
      zio.aws.transfer.model.TagResourceRequest(
        arn,
        tags.map { item =>
          item.asEditable
        }
      )
    def arn: Arn
    def tags: List[zio.aws.transfer.model.Tag.ReadOnly]
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getTags: ZIO[Any, Nothing, List[zio.aws.transfer.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.TagResourceRequest
  ) extends zio.aws.transfer.model.TagResourceRequest.ReadOnly {
    override val arn: Arn = zio.aws.transfer.model.primitives.Arn(impl.arn())
    override val tags: List[zio.aws.transfer.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.transfer.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.TagResourceRequest
  ): zio.aws.transfer.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
