package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{ExternalId, ServerId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateAccessResponse(
    serverId: ServerId,
    externalId: ExternalId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.UpdateAccessResponse = {
    import UpdateAccessResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.UpdateAccessResponse
      .builder()
      .serverId(ServerId.unwrap(serverId): java.lang.String)
      .externalId(ExternalId.unwrap(externalId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.UpdateAccessResponse.ReadOnly =
    zio.aws.transfer.model.UpdateAccessResponse.wrap(buildAwsValue())
}
object UpdateAccessResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.UpdateAccessResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.UpdateAccessResponse =
      zio.aws.transfer.model.UpdateAccessResponse(serverId, externalId)
    def serverId: ServerId
    def externalId: ExternalId
    def getServerId: ZIO[Any, Nothing, ServerId] = ZIO.succeed(serverId)
    def getExternalId: ZIO[Any, Nothing, ExternalId] = ZIO.succeed(externalId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.UpdateAccessResponse
  ) extends zio.aws.transfer.model.UpdateAccessResponse.ReadOnly {
    override val serverId: ServerId =
      zio.aws.transfer.model.primitives.ServerId(impl.serverId())
    override val externalId: ExternalId =
      zio.aws.transfer.model.primitives.ExternalId(impl.externalId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.UpdateAccessResponse
  ): zio.aws.transfer.model.UpdateAccessResponse.ReadOnly = new Wrapper(impl)
}
