package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.ServerId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateServerResponse(serverId: ServerId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.UpdateServerResponse = {
    import UpdateServerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.UpdateServerResponse
      .builder()
      .serverId(ServerId.unwrap(serverId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.UpdateServerResponse.ReadOnly =
    zio.aws.transfer.model.UpdateServerResponse.wrap(buildAwsValue())
}
object UpdateServerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.UpdateServerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.UpdateServerResponse =
      zio.aws.transfer.model.UpdateServerResponse(serverId)
    def serverId: ServerId
    def getServerId: ZIO[Any, Nothing, ServerId] = ZIO.succeed(serverId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.UpdateServerResponse
  ) extends zio.aws.transfer.model.UpdateServerResponse.ReadOnly {
    override val serverId: ServerId =
      zio.aws.transfer.model.primitives.ServerId(impl.serverId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.UpdateServerResponse
  ): zio.aws.transfer.model.UpdateServerResponse.ReadOnly = new Wrapper(impl)
}
