package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{UserName, ServerId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateUserResponse(serverId: ServerId, userName: UserName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.UpdateUserResponse = {
    import UpdateUserResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.UpdateUserResponse
      .builder()
      .serverId(ServerId.unwrap(serverId): java.lang.String)
      .userName(UserName.unwrap(userName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.UpdateUserResponse.ReadOnly =
    zio.aws.transfer.model.UpdateUserResponse.wrap(buildAwsValue())
}
object UpdateUserResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.UpdateUserResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.UpdateUserResponse =
      zio.aws.transfer.model.UpdateUserResponse(serverId, userName)
    def serverId: ServerId
    def userName: UserName
    def getServerId: ZIO[Any, Nothing, ServerId] = ZIO.succeed(serverId)
    def getUserName: ZIO[Any, Nothing, UserName] = ZIO.succeed(userName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.UpdateUserResponse
  ) extends zio.aws.transfer.model.UpdateUserResponse.ReadOnly {
    override val serverId: ServerId =
      zio.aws.transfer.model.primitives.ServerId(impl.serverId())
    override val userName: UserName =
      zio.aws.transfer.model.primitives.UserName(impl.userName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.UpdateUserResponse
  ): zio.aws.transfer.model.UpdateUserResponse.ReadOnly = new Wrapper(impl)
}
