package zio.aws.transfer
import zio.aws.transfer.model.primitives.{
  SubnetId,
  SecurityPolicyOption,
  SecurityGroupId,
  AddressAllocationId,
  PosixId,
  SecurityPolicyName,
  TagKey
}
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.transfer.model.primitives.HomeDirectory.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AddressAllocationId extends Subtype[String]
    type AddressAllocationId =
      zio.aws.transfer.model.primitives.AddressAllocationId.Type
    object Arn extends Subtype[String]
    type Arn = zio.aws.transfer.model.primitives.Arn.Type
    object CallbackToken extends Subtype[String]
    type CallbackToken = zio.aws.transfer.model.primitives.CallbackToken.Type
    object Certificate extends Subtype[String]
    type Certificate = zio.aws.transfer.model.primitives.Certificate.Type
    object CustomStepTarget extends Subtype[String]
    type CustomStepTarget =
      zio.aws.transfer.model.primitives.CustomStepTarget.Type
    object CustomStepTimeoutSeconds extends Subtype[Int]
    type CustomStepTimeoutSeconds =
      zio.aws.transfer.model.primitives.CustomStepTimeoutSeconds.Type
    object DateImported extends Subtype[Instant]
    type DateImported = zio.aws.transfer.model.primitives.DateImported.Type
    object DirectoryId extends Subtype[String]
    type DirectoryId = zio.aws.transfer.model.primitives.DirectoryId.Type
    object EfsFileSystemId extends Subtype[String]
    type EfsFileSystemId =
      zio.aws.transfer.model.primitives.EfsFileSystemId.Type
    object EfsPath extends Subtype[String]
    type EfsPath = zio.aws.transfer.model.primitives.EfsPath.Type
    object ExecutionErrorMessage extends Subtype[String]
    type ExecutionErrorMessage =
      zio.aws.transfer.model.primitives.ExecutionErrorMessage.Type
    object ExecutionId extends Subtype[String]
    type ExecutionId = zio.aws.transfer.model.primitives.ExecutionId.Type
    object ExternalId extends Subtype[String]
    type ExternalId = zio.aws.transfer.model.primitives.ExternalId.Type
    object Fips extends Subtype[Boolean]
    type Fips = zio.aws.transfer.model.primitives.Fips.Type
    object Function extends Subtype[String]
    type Function = zio.aws.transfer.model.primitives.Function.Type
    object HomeDirectory extends Subtype[String]
    type HomeDirectory = zio.aws.transfer.model.primitives.HomeDirectory.Type
    object HostKey extends Subtype[String]
    type HostKey = zio.aws.transfer.model.primitives.HostKey.Type
    object HostKeyFingerprint extends Subtype[String]
    type HostKeyFingerprint =
      zio.aws.transfer.model.primitives.HostKeyFingerprint.Type
    object LogGroupName extends Subtype[String]
    type LogGroupName = zio.aws.transfer.model.primitives.LogGroupName.Type
    object MapEntry extends Subtype[String]
    type MapEntry = zio.aws.transfer.model.primitives.MapEntry.Type
    object MapTarget extends Subtype[String]
    type MapTarget = zio.aws.transfer.model.primitives.MapTarget.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.transfer.model.primitives.MaxResults.Type
    object Message extends Subtype[String]
    type Message = zio.aws.transfer.model.primitives.Message.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.transfer.model.primitives.NextToken.Type
    object NullableRole extends Subtype[String]
    type NullableRole = zio.aws.transfer.model.primitives.NullableRole.Type
    object PassiveIp extends Subtype[String]
    type PassiveIp = zio.aws.transfer.model.primitives.PassiveIp.Type
    object Policy extends Subtype[String]
    type Policy = zio.aws.transfer.model.primitives.Policy.Type
    object PosixId extends Subtype[Long]
    type PosixId = zio.aws.transfer.model.primitives.PosixId.Type
    object PostAuthenticationLoginBanner extends Subtype[String]
    type PostAuthenticationLoginBanner =
      zio.aws.transfer.model.primitives.PostAuthenticationLoginBanner.Type
    object PreAuthenticationLoginBanner extends Subtype[String]
    type PreAuthenticationLoginBanner =
      zio.aws.transfer.model.primitives.PreAuthenticationLoginBanner.Type
    object Response extends Subtype[String]
    type Response = zio.aws.transfer.model.primitives.Response.Type
    object Role extends Subtype[String]
    type Role = zio.aws.transfer.model.primitives.Role.Type
    object S3Bucket extends Subtype[String]
    type S3Bucket = zio.aws.transfer.model.primitives.S3Bucket.Type
    object S3Etag extends Subtype[String]
    type S3Etag = zio.aws.transfer.model.primitives.S3Etag.Type
    object S3Key extends Subtype[String]
    type S3Key = zio.aws.transfer.model.primitives.S3Key.Type
    object S3TagKey extends Subtype[String]
    type S3TagKey = zio.aws.transfer.model.primitives.S3TagKey.Type
    object S3TagValue extends Subtype[String]
    type S3TagValue = zio.aws.transfer.model.primitives.S3TagValue.Type
    object S3VersionId extends Subtype[String]
    type S3VersionId = zio.aws.transfer.model.primitives.S3VersionId.Type
    object SecurityGroupId extends Subtype[String]
    type SecurityGroupId =
      zio.aws.transfer.model.primitives.SecurityGroupId.Type
    object SecurityPolicyName extends Subtype[String]
    type SecurityPolicyName =
      zio.aws.transfer.model.primitives.SecurityPolicyName.Type
    object SecurityPolicyOption extends Subtype[String]
    type SecurityPolicyOption =
      zio.aws.transfer.model.primitives.SecurityPolicyOption.Type
    object ServerId extends Subtype[String]
    type ServerId = zio.aws.transfer.model.primitives.ServerId.Type
    object SessionId extends Subtype[String]
    type SessionId = zio.aws.transfer.model.primitives.SessionId.Type
    object SourceFileLocation extends Subtype[String]
    type SourceFileLocation =
      zio.aws.transfer.model.primitives.SourceFileLocation.Type
    object SourceIp extends Subtype[String]
    type SourceIp = zio.aws.transfer.model.primitives.SourceIp.Type
    object SshPublicKeyBody extends Subtype[String]
    type SshPublicKeyBody =
      zio.aws.transfer.model.primitives.SshPublicKeyBody.Type
    object SshPublicKeyCount extends Subtype[Int]
    type SshPublicKeyCount =
      zio.aws.transfer.model.primitives.SshPublicKeyCount.Type
    object SshPublicKeyId extends Subtype[String]
    type SshPublicKeyId = zio.aws.transfer.model.primitives.SshPublicKeyId.Type
    object StatusCode extends Subtype[Int]
    type StatusCode = zio.aws.transfer.model.primitives.StatusCode.Type
    object StepResultOutputsJson extends Subtype[String]
    type StepResultOutputsJson =
      zio.aws.transfer.model.primitives.StepResultOutputsJson.Type
    object SubnetId extends Subtype[String]
    type SubnetId = zio.aws.transfer.model.primitives.SubnetId.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.transfer.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.transfer.model.primitives.TagValue.Type
    object Url extends Subtype[String]
    type Url = zio.aws.transfer.model.primitives.Url.Type
    object UserCount extends Subtype[Int]
    type UserCount = zio.aws.transfer.model.primitives.UserCount.Type
    object UserName extends Subtype[String]
    type UserName = zio.aws.transfer.model.primitives.UserName.Type
    object UserPassword extends Subtype[String]
    type UserPassword = zio.aws.transfer.model.primitives.UserPassword.Type
    object VpcEndpointId extends Subtype[String]
    type VpcEndpointId = zio.aws.transfer.model.primitives.VpcEndpointId.Type
    object VpcId extends Subtype[String]
    type VpcId = zio.aws.transfer.model.primitives.VpcId.Type
    object WorkflowDescription extends Subtype[String]
    type WorkflowDescription =
      zio.aws.transfer.model.primitives.WorkflowDescription.Type
    object WorkflowId extends Subtype[String]
    type WorkflowId = zio.aws.transfer.model.primitives.WorkflowId.Type
    object WorkflowStepName extends Subtype[String]
    type WorkflowStepName =
      zio.aws.transfer.model.primitives.WorkflowStepName.Type
  }
  type AddressAllocationIds = List[AddressAllocationId]
  type ExecutionStepResults = List[zio.aws.transfer.model.ExecutionStepResult]
  type HomeDirectoryMappings =
    List[zio.aws.transfer.model.HomeDirectoryMapEntry]
  type ListedAccesses = List[zio.aws.transfer.model.ListedAccess]
  type ListedExecutions = List[zio.aws.transfer.model.ListedExecution]
  type ListedServers = List[zio.aws.transfer.model.ListedServer]
  type ListedUsers = List[zio.aws.transfer.model.ListedUser]
  type ListedWorkflows = List[zio.aws.transfer.model.ListedWorkflow]
  type OnUploadWorkflowDetails = List[zio.aws.transfer.model.WorkflowDetail]
  type Protocols = List[zio.aws.transfer.model.Protocol]
  type S3Tags = List[zio.aws.transfer.model.S3Tag]
  type SecondaryGids = List[PosixId]
  type SecurityGroupIds = List[SecurityGroupId]
  type SecurityPolicyNames = List[SecurityPolicyName]
  type SecurityPolicyOptions = List[SecurityPolicyOption]
  type SshPublicKeys = List[zio.aws.transfer.model.SshPublicKey]
  type SubnetIds = List[SubnetId]
  type TagKeys = List[TagKey]
  type Tags = List[zio.aws.transfer.model.Tag]
  type WorkflowSteps = List[zio.aws.transfer.model.WorkflowStep]
}
