package zio.aws.transfer
import zio.aws.transfer.model.DescribeExecutionResponse.ReadOnly
import software.amazon.awssdk.services.transfer.model.{
  ImportSshPublicKeyResponse,
  DeleteUserRequest,
  ListServersRequest,
  ListSecurityPoliciesResponse,
  CreateWorkflowRequest,
  CreateAccessRequest,
  DescribeUserRequest,
  TestIdentityProviderResponse,
  ListedWorkflow,
  DescribeServerRequest,
  StopServerRequest,
  DeleteSshPublicKeyRequest,
  ListedAccess,
  UpdateAccessRequest,
  DeleteWorkflowResponse,
  ListSecurityPoliciesRequest,
  ListUsersRequest,
  DescribeExecutionResponse,
  ListUsersResponse,
  ListWorkflowsRequest,
  DescribeUserResponse,
  ListedExecution,
  UpdateServerResponse,
  StartServerResponse,
  ListTagsForResourceRequest,
  Tag,
  CreateWorkflowResponse,
  DescribeServerResponse,
  ListTagsForResourceResponse,
  DeleteServerResponse,
  DescribeAccessResponse,
  UntagResourceResponse,
  DeleteServerRequest,
  ListAccessesResponse,
  ListWorkflowsResponse,
  CreateUserRequest,
  DescribeWorkflowRequest,
  ListedServer,
  ListExecutionsRequest,
  DeleteSshPublicKeyResponse,
  CreateUserResponse,
  DeleteAccessRequest,
  UpdateServerRequest,
  DescribeSecurityPolicyResponse,
  SendWorkflowStepStateRequest,
  DescribeWorkflowResponse,
  ListServersResponse,
  ListAccessesRequest,
  ListExecutionsResponse,
  DescribeAccessRequest,
  CreateAccessResponse,
  UntagResourceRequest,
  UpdateAccessResponse,
  DeleteUserResponse,
  StopServerResponse,
  DescribeSecurityPolicyRequest,
  ImportSshPublicKeyRequest,
  UpdateUserRequest,
  CreateServerRequest,
  DeleteAccessResponse,
  UpdateUserResponse,
  TagResourceResponse,
  DeleteWorkflowRequest,
  ListedUser,
  DescribeExecutionRequest,
  TagResourceRequest,
  StartServerRequest,
  CreateServerResponse,
  SendWorkflowStepStateResponse,
  TestIdentityProviderRequest
}
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.transfer.{
  TransferAsyncClientBuilder,
  TransferAsyncClient
}
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import zio.aws.transfer.model.primitives.SecurityPolicyName
import scala.jdk.CollectionConverters._
trait Transfer extends AspectSupport[Transfer] {
  val api: TransferAsyncClient
  def updateServer(
      request: zio.aws.transfer.model.UpdateServerRequest
  ): IO[AwsError, zio.aws.transfer.model.UpdateServerResponse.ReadOnly]
  def listUsers(
      request: zio.aws.transfer.model.ListUsersRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.transfer.model.ListUsersResponse.ReadOnly,
    zio.aws.transfer.model.ListedUser.ReadOnly
  ]]
  def listUsersPaginated(
      request: zio.aws.transfer.model.ListUsersRequest
  ): IO[AwsError, zio.aws.transfer.model.ListUsersResponse.ReadOnly]
  def updateUser(
      request: zio.aws.transfer.model.UpdateUserRequest
  ): IO[AwsError, zio.aws.transfer.model.UpdateUserResponse.ReadOnly]
  def deleteServer(
      request: zio.aws.transfer.model.DeleteServerRequest
  ): IO[AwsError, Unit]
  def describeWorkflow(
      request: zio.aws.transfer.model.DescribeWorkflowRequest
  ): IO[AwsError, zio.aws.transfer.model.DescribeWorkflowResponse.ReadOnly]
  def describeServer(
      request: zio.aws.transfer.model.DescribeServerRequest
  ): IO[AwsError, zio.aws.transfer.model.DescribeServerResponse.ReadOnly]
  def listSecurityPolicies(
      request: zio.aws.transfer.model.ListSecurityPoliciesRequest
  ): ZStream[Any, AwsError, SecurityPolicyName]
  def listSecurityPoliciesPaginated(
      request: zio.aws.transfer.model.ListSecurityPoliciesRequest
  ): IO[AwsError, zio.aws.transfer.model.ListSecurityPoliciesResponse.ReadOnly]
  def createAccess(
      request: zio.aws.transfer.model.CreateAccessRequest
  ): IO[AwsError, zio.aws.transfer.model.CreateAccessResponse.ReadOnly]
  def startServer(
      request: zio.aws.transfer.model.StartServerRequest
  ): IO[AwsError, Unit]
  def importSshPublicKey(
      request: zio.aws.transfer.model.ImportSshPublicKeyRequest
  ): IO[AwsError, zio.aws.transfer.model.ImportSshPublicKeyResponse.ReadOnly]
  def describeExecution(
      request: zio.aws.transfer.model.DescribeExecutionRequest
  ): IO[AwsError, ReadOnly]
  def createUser(
      request: zio.aws.transfer.model.CreateUserRequest
  ): IO[AwsError, zio.aws.transfer.model.CreateUserResponse.ReadOnly]
  def stopServer(
      request: zio.aws.transfer.model.StopServerRequest
  ): IO[AwsError, Unit]
  def listAccesses(
      request: zio.aws.transfer.model.ListAccessesRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.transfer.model.ListAccessesResponse.ReadOnly,
    zio.aws.transfer.model.ListedAccess.ReadOnly
  ]]
  def listAccessesPaginated(
      request: zio.aws.transfer.model.ListAccessesRequest
  ): IO[AwsError, zio.aws.transfer.model.ListAccessesResponse.ReadOnly]
  def describeAccess(
      request: zio.aws.transfer.model.DescribeAccessRequest
  ): IO[AwsError, zio.aws.transfer.model.DescribeAccessResponse.ReadOnly]
  def sendWorkflowStepState(
      request: zio.aws.transfer.model.SendWorkflowStepStateRequest
  ): IO[AwsError, zio.aws.transfer.model.SendWorkflowStepStateResponse.ReadOnly]
  def deleteAccess(
      request: zio.aws.transfer.model.DeleteAccessRequest
  ): IO[AwsError, Unit]
  def untagResource(
      request: zio.aws.transfer.model.UntagResourceRequest
  ): IO[AwsError, Unit]
  def listExecutions(
      request: zio.aws.transfer.model.ListExecutionsRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.transfer.model.ListExecutionsResponse.ReadOnly,
    zio.aws.transfer.model.ListedExecution.ReadOnly
  ]]
  def listExecutionsPaginated(
      request: zio.aws.transfer.model.ListExecutionsRequest
  ): IO[AwsError, zio.aws.transfer.model.ListExecutionsResponse.ReadOnly]
  def describeUser(
      request: zio.aws.transfer.model.DescribeUserRequest
  ): IO[AwsError, zio.aws.transfer.model.DescribeUserResponse.ReadOnly]
  def listTagsForResource(
      request: zio.aws.transfer.model.ListTagsForResourceRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.transfer.model.ListTagsForResourceResponse.ReadOnly,
    zio.aws.transfer.model.Tag.ReadOnly
  ]]
  def listTagsForResourcePaginated(
      request: zio.aws.transfer.model.ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.transfer.model.ListTagsForResourceResponse.ReadOnly]
  def createServer(
      request: zio.aws.transfer.model.CreateServerRequest
  ): IO[AwsError, zio.aws.transfer.model.CreateServerResponse.ReadOnly]
  def tagResource(
      request: zio.aws.transfer.model.TagResourceRequest
  ): IO[AwsError, Unit]
  def testIdentityProvider(
      request: zio.aws.transfer.model.TestIdentityProviderRequest
  ): IO[AwsError, zio.aws.transfer.model.TestIdentityProviderResponse.ReadOnly]
  def updateAccess(
      request: zio.aws.transfer.model.UpdateAccessRequest
  ): IO[AwsError, zio.aws.transfer.model.UpdateAccessResponse.ReadOnly]
  def listWorkflows(
      request: zio.aws.transfer.model.ListWorkflowsRequest
  ): ZStream[Any, AwsError, zio.aws.transfer.model.ListedWorkflow.ReadOnly]
  def listWorkflowsPaginated(
      request: zio.aws.transfer.model.ListWorkflowsRequest
  ): IO[AwsError, zio.aws.transfer.model.ListWorkflowsResponse.ReadOnly]
  def deleteUser(
      request: zio.aws.transfer.model.DeleteUserRequest
  ): IO[AwsError, Unit]
  def describeSecurityPolicy(
      request: zio.aws.transfer.model.DescribeSecurityPolicyRequest
  ): IO[
    AwsError,
    zio.aws.transfer.model.DescribeSecurityPolicyResponse.ReadOnly
  ]
  def deleteSshPublicKey(
      request: zio.aws.transfer.model.DeleteSshPublicKeyRequest
  ): IO[AwsError, Unit]
  def deleteWorkflow(
      request: zio.aws.transfer.model.DeleteWorkflowRequest
  ): IO[AwsError, Unit]
  def createWorkflow(
      request: zio.aws.transfer.model.CreateWorkflowRequest
  ): IO[AwsError, zio.aws.transfer.model.CreateWorkflowResponse.ReadOnly]
  def listServers(
      request: zio.aws.transfer.model.ListServersRequest
  ): ZStream[Any, AwsError, zio.aws.transfer.model.ListedServer.ReadOnly]
  def listServersPaginated(
      request: zio.aws.transfer.model.ListServersRequest
  ): IO[AwsError, zio.aws.transfer.model.ListServersResponse.ReadOnly]
}
object Transfer {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Transfer] = customized(
    identity
  )
  def customized(
      customization: TransferAsyncClientBuilder => TransferAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Transfer] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: TransferAsyncClientBuilder => TransferAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Transfer] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = TransferAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[TransferAsyncClient, TransferAsyncClientBuilder](
      builder
    );
    b1 <- awsConfig
      .configureHttpClient[TransferAsyncClient, TransferAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new TransferImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class TransferImpl[R](
      override val api: TransferAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Transfer
      with AwsServiceBase[R] {
    override val serviceName: String = "Transfer"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): TransferImpl[R1] = new TransferImpl(api, newAspect, r)
    def updateServer(
        request: zio.aws.transfer.model.UpdateServerRequest
    ): IO[AwsError, zio.aws.transfer.model.UpdateServerResponse.ReadOnly] =
      asyncRequestResponse[UpdateServerRequest, UpdateServerResponse](
        "updateServer",
        api.updateServer
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.UpdateServerResponse.wrap)
        .provideEnvironment(r)
    def listUsers(
        request: zio.aws.transfer.model.ListUsersRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.transfer.model.ListUsersResponse.ReadOnly,
      zio.aws.transfer.model.ListedUser.ReadOnly
    ]] = asyncPaginatedRequest[ListUsersRequest, ListUsersResponse, ListedUser](
      "listUsers",
      api.listUsers,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.users().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.transfer.model.ListUsersResponse.wrap)
          .mapOutput(
            _.map(item => zio.aws.transfer.model.ListedUser.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listUsersPaginated(
        request: zio.aws.transfer.model.ListUsersRequest
    ): IO[AwsError, zio.aws.transfer.model.ListUsersResponse.ReadOnly] =
      asyncRequestResponse[ListUsersRequest, ListUsersResponse](
        "listUsers",
        api.listUsers
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.ListUsersResponse.wrap)
        .provideEnvironment(r)
    def updateUser(
        request: zio.aws.transfer.model.UpdateUserRequest
    ): IO[AwsError, zio.aws.transfer.model.UpdateUserResponse.ReadOnly] =
      asyncRequestResponse[UpdateUserRequest, UpdateUserResponse](
        "updateUser",
        api.updateUser
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.UpdateUserResponse.wrap)
        .provideEnvironment(r)
    def deleteServer(
        request: zio.aws.transfer.model.DeleteServerRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteServerRequest, DeleteServerResponse](
        "deleteServer",
        api.deleteServer
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def describeWorkflow(
        request: zio.aws.transfer.model.DescribeWorkflowRequest
    ): IO[AwsError, zio.aws.transfer.model.DescribeWorkflowResponse.ReadOnly] =
      asyncRequestResponse[DescribeWorkflowRequest, DescribeWorkflowResponse](
        "describeWorkflow",
        api.describeWorkflow
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.DescribeWorkflowResponse.wrap)
        .provideEnvironment(r)
    def describeServer(
        request: zio.aws.transfer.model.DescribeServerRequest
    ): IO[AwsError, zio.aws.transfer.model.DescribeServerResponse.ReadOnly] =
      asyncRequestResponse[DescribeServerRequest, DescribeServerResponse](
        "describeServer",
        api.describeServer
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.DescribeServerResponse.wrap)
        .provideEnvironment(r)
    def listSecurityPolicies(
        request: zio.aws.transfer.model.ListSecurityPoliciesRequest
    ): ZStream[Any, AwsError, SecurityPolicyName] = asyncSimplePaginatedRequest[
      ListSecurityPoliciesRequest,
      ListSecurityPoliciesResponse,
      java.lang.String
    ](
      "listSecurityPolicies",
      api.listSecurityPolicies,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.securityPolicyNames().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.transfer.model.primitives.SecurityPolicyName(item))
      .provideEnvironment(r)
    def listSecurityPoliciesPaginated(
        request: zio.aws.transfer.model.ListSecurityPoliciesRequest
    ): IO[
      AwsError,
      zio.aws.transfer.model.ListSecurityPoliciesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListSecurityPoliciesRequest,
      ListSecurityPoliciesResponse
    ]("listSecurityPolicies", api.listSecurityPolicies)(request.buildAwsValue())
      .map(zio.aws.transfer.model.ListSecurityPoliciesResponse.wrap)
      .provideEnvironment(r)
    def createAccess(
        request: zio.aws.transfer.model.CreateAccessRequest
    ): IO[AwsError, zio.aws.transfer.model.CreateAccessResponse.ReadOnly] =
      asyncRequestResponse[CreateAccessRequest, CreateAccessResponse](
        "createAccess",
        api.createAccess
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.CreateAccessResponse.wrap)
        .provideEnvironment(r)
    def startServer(
        request: zio.aws.transfer.model.StartServerRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[StartServerRequest, StartServerResponse](
        "startServer",
        api.startServer
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def importSshPublicKey(
        request: zio.aws.transfer.model.ImportSshPublicKeyRequest
    ): IO[
      AwsError,
      zio.aws.transfer.model.ImportSshPublicKeyResponse.ReadOnly
    ] = asyncRequestResponse[
      ImportSshPublicKeyRequest,
      ImportSshPublicKeyResponse
    ]("importSshPublicKey", api.importSshPublicKey)(request.buildAwsValue())
      .map(zio.aws.transfer.model.ImportSshPublicKeyResponse.wrap)
      .provideEnvironment(r)
    def describeExecution(
        request: zio.aws.transfer.model.DescribeExecutionRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[DescribeExecutionRequest, DescribeExecutionResponse](
        "describeExecution",
        api.describeExecution
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.DescribeExecutionResponse.wrap)
        .provideEnvironment(r)
    def createUser(
        request: zio.aws.transfer.model.CreateUserRequest
    ): IO[AwsError, zio.aws.transfer.model.CreateUserResponse.ReadOnly] =
      asyncRequestResponse[CreateUserRequest, CreateUserResponse](
        "createUser",
        api.createUser
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.CreateUserResponse.wrap)
        .provideEnvironment(r)
    def stopServer(
        request: zio.aws.transfer.model.StopServerRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[StopServerRequest, StopServerResponse](
        "stopServer",
        api.stopServer
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def listAccesses(
        request: zio.aws.transfer.model.ListAccessesRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.transfer.model.ListAccessesResponse.ReadOnly,
      zio.aws.transfer.model.ListedAccess.ReadOnly
    ]] = asyncPaginatedRequest[
      ListAccessesRequest,
      ListAccessesResponse,
      ListedAccess
    ](
      "listAccesses",
      api.listAccesses,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.accesses().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.transfer.model.ListAccessesResponse.wrap)
          .mapOutput(
            _.map(item => zio.aws.transfer.model.ListedAccess.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listAccessesPaginated(
        request: zio.aws.transfer.model.ListAccessesRequest
    ): IO[AwsError, zio.aws.transfer.model.ListAccessesResponse.ReadOnly] =
      asyncRequestResponse[ListAccessesRequest, ListAccessesResponse](
        "listAccesses",
        api.listAccesses
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.ListAccessesResponse.wrap)
        .provideEnvironment(r)
    def describeAccess(
        request: zio.aws.transfer.model.DescribeAccessRequest
    ): IO[AwsError, zio.aws.transfer.model.DescribeAccessResponse.ReadOnly] =
      asyncRequestResponse[DescribeAccessRequest, DescribeAccessResponse](
        "describeAccess",
        api.describeAccess
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.DescribeAccessResponse.wrap)
        .provideEnvironment(r)
    def sendWorkflowStepState(
        request: zio.aws.transfer.model.SendWorkflowStepStateRequest
    ): IO[
      AwsError,
      zio.aws.transfer.model.SendWorkflowStepStateResponse.ReadOnly
    ] = asyncRequestResponse[
      SendWorkflowStepStateRequest,
      SendWorkflowStepStateResponse
    ]("sendWorkflowStepState", api.sendWorkflowStepState)(
      request.buildAwsValue()
    ).map(zio.aws.transfer.model.SendWorkflowStepStateResponse.wrap)
      .provideEnvironment(r)
    def deleteAccess(
        request: zio.aws.transfer.model.DeleteAccessRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteAccessRequest, DeleteAccessResponse](
        "deleteAccess",
        api.deleteAccess
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def untagResource(
        request: zio.aws.transfer.model.UntagResourceRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def listExecutions(
        request: zio.aws.transfer.model.ListExecutionsRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.transfer.model.ListExecutionsResponse.ReadOnly,
      zio.aws.transfer.model.ListedExecution.ReadOnly
    ]] = asyncPaginatedRequest[
      ListExecutionsRequest,
      ListExecutionsResponse,
      ListedExecution
    ](
      "listExecutions",
      api.listExecutions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.executions().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.transfer.model.ListExecutionsResponse.wrap)
          .mapOutput(
            _.map(item => zio.aws.transfer.model.ListedExecution.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listExecutionsPaginated(
        request: zio.aws.transfer.model.ListExecutionsRequest
    ): IO[AwsError, zio.aws.transfer.model.ListExecutionsResponse.ReadOnly] =
      asyncRequestResponse[ListExecutionsRequest, ListExecutionsResponse](
        "listExecutions",
        api.listExecutions
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.ListExecutionsResponse.wrap)
        .provideEnvironment(r)
    def describeUser(
        request: zio.aws.transfer.model.DescribeUserRequest
    ): IO[AwsError, zio.aws.transfer.model.DescribeUserResponse.ReadOnly] =
      asyncRequestResponse[DescribeUserRequest, DescribeUserResponse](
        "describeUser",
        api.describeUser
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.DescribeUserResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.transfer.model.ListTagsForResourceRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.transfer.model.ListTagsForResourceResponse.ReadOnly,
      zio.aws.transfer.model.Tag.ReadOnly
    ]] = asyncPaginatedRequest[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse,
      Tag
    ](
      "listTagsForResource",
      api.listTagsForResource,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.tags().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.transfer.model.ListTagsForResourceResponse.wrap)
          .mapOutput(_.map(item => zio.aws.transfer.model.Tag.wrap(item)))
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listTagsForResourcePaginated(
        request: zio.aws.transfer.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.transfer.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.transfer.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def createServer(
        request: zio.aws.transfer.model.CreateServerRequest
    ): IO[AwsError, zio.aws.transfer.model.CreateServerResponse.ReadOnly] =
      asyncRequestResponse[CreateServerRequest, CreateServerResponse](
        "createServer",
        api.createServer
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.CreateServerResponse.wrap)
        .provideEnvironment(r)
    def tagResource(
        request: zio.aws.transfer.model.TagResourceRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def testIdentityProvider(
        request: zio.aws.transfer.model.TestIdentityProviderRequest
    ): IO[
      AwsError,
      zio.aws.transfer.model.TestIdentityProviderResponse.ReadOnly
    ] = asyncRequestResponse[
      TestIdentityProviderRequest,
      TestIdentityProviderResponse
    ]("testIdentityProvider", api.testIdentityProvider)(request.buildAwsValue())
      .map(zio.aws.transfer.model.TestIdentityProviderResponse.wrap)
      .provideEnvironment(r)
    def updateAccess(
        request: zio.aws.transfer.model.UpdateAccessRequest
    ): IO[AwsError, zio.aws.transfer.model.UpdateAccessResponse.ReadOnly] =
      asyncRequestResponse[UpdateAccessRequest, UpdateAccessResponse](
        "updateAccess",
        api.updateAccess
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.UpdateAccessResponse.wrap)
        .provideEnvironment(r)
    def listWorkflows(
        request: zio.aws.transfer.model.ListWorkflowsRequest
    ): ZStream[Any, AwsError, zio.aws.transfer.model.ListedWorkflow.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListWorkflowsRequest,
        ListWorkflowsResponse,
        ListedWorkflow
      ](
        "listWorkflows",
        api.listWorkflows,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.workflows().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.transfer.model.ListedWorkflow.wrap(item))
        .provideEnvironment(r)
    def listWorkflowsPaginated(
        request: zio.aws.transfer.model.ListWorkflowsRequest
    ): IO[AwsError, zio.aws.transfer.model.ListWorkflowsResponse.ReadOnly] =
      asyncRequestResponse[ListWorkflowsRequest, ListWorkflowsResponse](
        "listWorkflows",
        api.listWorkflows
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.ListWorkflowsResponse.wrap)
        .provideEnvironment(r)
    def deleteUser(
        request: zio.aws.transfer.model.DeleteUserRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteUserRequest, DeleteUserResponse](
        "deleteUser",
        api.deleteUser
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def describeSecurityPolicy(
        request: zio.aws.transfer.model.DescribeSecurityPolicyRequest
    ): IO[
      AwsError,
      zio.aws.transfer.model.DescribeSecurityPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeSecurityPolicyRequest,
      DescribeSecurityPolicyResponse
    ]("describeSecurityPolicy", api.describeSecurityPolicy)(
      request.buildAwsValue()
    ).map(zio.aws.transfer.model.DescribeSecurityPolicyResponse.wrap)
      .provideEnvironment(r)
    def deleteSshPublicKey(
        request: zio.aws.transfer.model.DeleteSshPublicKeyRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteSshPublicKeyRequest,
      DeleteSshPublicKeyResponse
    ]("deleteSshPublicKey", api.deleteSshPublicKey)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteWorkflow(
        request: zio.aws.transfer.model.DeleteWorkflowRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteWorkflowRequest, DeleteWorkflowResponse](
        "deleteWorkflow",
        api.deleteWorkflow
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def createWorkflow(
        request: zio.aws.transfer.model.CreateWorkflowRequest
    ): IO[AwsError, zio.aws.transfer.model.CreateWorkflowResponse.ReadOnly] =
      asyncRequestResponse[CreateWorkflowRequest, CreateWorkflowResponse](
        "createWorkflow",
        api.createWorkflow
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.CreateWorkflowResponse.wrap)
        .provideEnvironment(r)
    def listServers(
        request: zio.aws.transfer.model.ListServersRequest
    ): ZStream[Any, AwsError, zio.aws.transfer.model.ListedServer.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListServersRequest,
        ListServersResponse,
        ListedServer
      ](
        "listServers",
        api.listServers,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.servers().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.transfer.model.ListedServer.wrap(item))
        .provideEnvironment(r)
    def listServersPaginated(
        request: zio.aws.transfer.model.ListServersRequest
    ): IO[AwsError, zio.aws.transfer.model.ListServersResponse.ReadOnly] =
      asyncRequestResponse[ListServersRequest, ListServersResponse](
        "listServers",
        api.listServers
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.ListServersResponse.wrap)
        .provideEnvironment(r)
  }
  def updateServer(request: zio.aws.transfer.model.UpdateServerRequest): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.UpdateServerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateServer(request))
  def listUsers(
      request: zio.aws.transfer.model.ListUsersRequest
  ): ZIO[zio.aws.transfer.Transfer, AwsError, StreamingOutputResult[
    Any,
    zio.aws.transfer.model.ListUsersResponse.ReadOnly,
    zio.aws.transfer.model.ListedUser.ReadOnly
  ]] = ZIO.serviceWithZIO(_.listUsers(request))
  def listUsersPaginated(request: zio.aws.transfer.model.ListUsersRequest): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.ListUsersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listUsersPaginated(request))
  def updateUser(request: zio.aws.transfer.model.UpdateUserRequest): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.UpdateUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateUser(request))
  def deleteServer(
      request: zio.aws.transfer.model.DeleteServerRequest
  ): ZIO[zio.aws.transfer.Transfer, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteServer(request))
  def describeWorkflow(
      request: zio.aws.transfer.model.DescribeWorkflowRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.DescribeWorkflowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeWorkflow(request))
  def describeServer(
      request: zio.aws.transfer.model.DescribeServerRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.DescribeServerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeServer(request))
  def listSecurityPolicies(
      request: zio.aws.transfer.model.ListSecurityPoliciesRequest
  ): ZStream[zio.aws.transfer.Transfer, AwsError, SecurityPolicyName] =
    ZStream.serviceWithStream(_.listSecurityPolicies(request))
  def listSecurityPoliciesPaginated(
      request: zio.aws.transfer.model.ListSecurityPoliciesRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.ListSecurityPoliciesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSecurityPoliciesPaginated(request))
  def createAccess(request: zio.aws.transfer.model.CreateAccessRequest): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.CreateAccessResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAccess(request))
  def startServer(
      request: zio.aws.transfer.model.StartServerRequest
  ): ZIO[zio.aws.transfer.Transfer, AwsError, Unit] =
    ZIO.serviceWithZIO(_.startServer(request))
  def importSshPublicKey(
      request: zio.aws.transfer.model.ImportSshPublicKeyRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.ImportSshPublicKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.importSshPublicKey(request))
  def describeExecution(
      request: zio.aws.transfer.model.DescribeExecutionRequest
  ): ZIO[zio.aws.transfer.Transfer, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.describeExecution(request))
  def createUser(request: zio.aws.transfer.model.CreateUserRequest): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.CreateUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createUser(request))
  def stopServer(
      request: zio.aws.transfer.model.StopServerRequest
  ): ZIO[zio.aws.transfer.Transfer, AwsError, Unit] =
    ZIO.serviceWithZIO(_.stopServer(request))
  def listAccesses(
      request: zio.aws.transfer.model.ListAccessesRequest
  ): ZIO[zio.aws.transfer.Transfer, AwsError, StreamingOutputResult[
    Any,
    zio.aws.transfer.model.ListAccessesResponse.ReadOnly,
    zio.aws.transfer.model.ListedAccess.ReadOnly
  ]] = ZIO.serviceWithZIO(_.listAccesses(request))
  def listAccessesPaginated(
      request: zio.aws.transfer.model.ListAccessesRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.ListAccessesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAccessesPaginated(request))
  def describeAccess(
      request: zio.aws.transfer.model.DescribeAccessRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.DescribeAccessResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAccess(request))
  def sendWorkflowStepState(
      request: zio.aws.transfer.model.SendWorkflowStepStateRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.SendWorkflowStepStateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.sendWorkflowStepState(request))
  def deleteAccess(
      request: zio.aws.transfer.model.DeleteAccessRequest
  ): ZIO[zio.aws.transfer.Transfer, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteAccess(request))
  def untagResource(
      request: zio.aws.transfer.model.UntagResourceRequest
  ): ZIO[zio.aws.transfer.Transfer, AwsError, Unit] =
    ZIO.serviceWithZIO(_.untagResource(request))
  def listExecutions(
      request: zio.aws.transfer.model.ListExecutionsRequest
  ): ZIO[zio.aws.transfer.Transfer, AwsError, StreamingOutputResult[
    Any,
    zio.aws.transfer.model.ListExecutionsResponse.ReadOnly,
    zio.aws.transfer.model.ListedExecution.ReadOnly
  ]] = ZIO.serviceWithZIO(_.listExecutions(request))
  def listExecutionsPaginated(
      request: zio.aws.transfer.model.ListExecutionsRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.ListExecutionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listExecutionsPaginated(request))
  def describeUser(request: zio.aws.transfer.model.DescribeUserRequest): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.DescribeUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeUser(request))
  def listTagsForResource(
      request: zio.aws.transfer.model.ListTagsForResourceRequest
  ): ZIO[zio.aws.transfer.Transfer, AwsError, StreamingOutputResult[
    Any,
    zio.aws.transfer.model.ListTagsForResourceResponse.ReadOnly,
    zio.aws.transfer.model.Tag.ReadOnly
  ]] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def listTagsForResourcePaginated(
      request: zio.aws.transfer.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResourcePaginated(request))
  def createServer(request: zio.aws.transfer.model.CreateServerRequest): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.CreateServerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createServer(request))
  def tagResource(
      request: zio.aws.transfer.model.TagResourceRequest
  ): ZIO[zio.aws.transfer.Transfer, AwsError, Unit] =
    ZIO.serviceWithZIO(_.tagResource(request))
  def testIdentityProvider(
      request: zio.aws.transfer.model.TestIdentityProviderRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.TestIdentityProviderResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.testIdentityProvider(request))
  def updateAccess(request: zio.aws.transfer.model.UpdateAccessRequest): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.UpdateAccessResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateAccess(request))
  def listWorkflows(
      request: zio.aws.transfer.model.ListWorkflowsRequest
  ): ZStream[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.ListedWorkflow.ReadOnly
  ] = ZStream.serviceWithStream(_.listWorkflows(request))
  def listWorkflowsPaginated(
      request: zio.aws.transfer.model.ListWorkflowsRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.ListWorkflowsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listWorkflowsPaginated(request))
  def deleteUser(
      request: zio.aws.transfer.model.DeleteUserRequest
  ): ZIO[zio.aws.transfer.Transfer, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteUser(request))
  def describeSecurityPolicy(
      request: zio.aws.transfer.model.DescribeSecurityPolicyRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.DescribeSecurityPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSecurityPolicy(request))
  def deleteSshPublicKey(
      request: zio.aws.transfer.model.DeleteSshPublicKeyRequest
  ): ZIO[zio.aws.transfer.Transfer, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteSshPublicKey(request))
  def deleteWorkflow(
      request: zio.aws.transfer.model.DeleteWorkflowRequest
  ): ZIO[zio.aws.transfer.Transfer, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteWorkflow(request))
  def createWorkflow(
      request: zio.aws.transfer.model.CreateWorkflowRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.CreateWorkflowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createWorkflow(request))
  def listServers(request: zio.aws.transfer.model.ListServersRequest): ZStream[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.ListedServer.ReadOnly
  ] = ZStream.serviceWithStream(_.listServers(request))
  def listServersPaginated(
      request: zio.aws.transfer.model.ListServersRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.ListServersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listServersPaginated(request))
}
