package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{UserName, ServerId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeUserRequest(serverId: ServerId, userName: UserName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.DescribeUserRequest = {
    import DescribeUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.DescribeUserRequest
      .builder()
      .serverId(ServerId.unwrap(serverId): java.lang.String)
      .userName(UserName.unwrap(userName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.DescribeUserRequest.ReadOnly =
    zio.aws.transfer.model.DescribeUserRequest.wrap(buildAwsValue())
}
object DescribeUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.DescribeUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.DescribeUserRequest =
      zio.aws.transfer.model.DescribeUserRequest(serverId, userName)
    def serverId: ServerId
    def userName: UserName
    def getServerId: ZIO[Any, Nothing, ServerId] = ZIO.succeed(serverId)
    def getUserName: ZIO[Any, Nothing, UserName] = ZIO.succeed(userName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.DescribeUserRequest
  ) extends zio.aws.transfer.model.DescribeUserRequest.ReadOnly {
    override val serverId: ServerId =
      zio.aws.transfer.model.primitives.ServerId(impl.serverId())
    override val userName: UserName =
      zio.aws.transfer.model.primitives.UserName(impl.userName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.DescribeUserRequest
  ): zio.aws.transfer.model.DescribeUserRequest.ReadOnly = new Wrapper(impl)
}
