package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{
  ExternalId,
  Role,
  Policy,
  HomeDirectory
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribedAccess(
    homeDirectory: Optional[HomeDirectory] = Optional.Absent,
    homeDirectoryMappings: Optional[
      Iterable[zio.aws.transfer.model.HomeDirectoryMapEntry]
    ] = Optional.Absent,
    homeDirectoryType: Optional[zio.aws.transfer.model.HomeDirectoryType] =
      Optional.Absent,
    policy: Optional[Policy] = Optional.Absent,
    posixProfile: Optional[zio.aws.transfer.model.PosixProfile] =
      Optional.Absent,
    role: Optional[Role] = Optional.Absent,
    externalId: Optional[ExternalId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.DescribedAccess = {
    import DescribedAccess.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.DescribedAccess
      .builder()
      .optionallyWith(
        homeDirectory.map(value =>
          HomeDirectory.unwrap(value): java.lang.String
        )
      )(_.homeDirectory)
      .optionallyWith(
        homeDirectoryMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.homeDirectoryMappings)
      .optionallyWith(homeDirectoryType.map(value => value.unwrap))(
        _.homeDirectoryType
      )
      .optionallyWith(
        policy.map(value => Policy.unwrap(value): java.lang.String)
      )(_.policy)
      .optionallyWith(posixProfile.map(value => value.buildAwsValue()))(
        _.posixProfile
      )
      .optionallyWith(role.map(value => Role.unwrap(value): java.lang.String))(
        _.role
      )
      .optionallyWith(
        externalId.map(value => ExternalId.unwrap(value): java.lang.String)
      )(_.externalId)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.DescribedAccess.ReadOnly =
    zio.aws.transfer.model.DescribedAccess.wrap(buildAwsValue())
}
object DescribedAccess {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.DescribedAccess
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.DescribedAccess =
      zio.aws.transfer.model.DescribedAccess(
        homeDirectory.map(value => value),
        homeDirectoryMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        homeDirectoryType.map(value => value),
        policy.map(value => value),
        posixProfile.map(value => value.asEditable),
        role.map(value => value),
        externalId.map(value => value)
      )
    def homeDirectory: Optional[HomeDirectory]
    def homeDirectoryMappings
        : Optional[List[zio.aws.transfer.model.HomeDirectoryMapEntry.ReadOnly]]
    def homeDirectoryType: Optional[zio.aws.transfer.model.HomeDirectoryType]
    def policy: Optional[Policy]
    def posixProfile: Optional[zio.aws.transfer.model.PosixProfile.ReadOnly]
    def role: Optional[Role]
    def externalId: Optional[ExternalId]
    def getHomeDirectory: ZIO[Any, AwsError, HomeDirectory] =
      AwsError.unwrapOptionField("homeDirectory", homeDirectory)
    def getHomeDirectoryMappings: ZIO[Any, AwsError, List[
      zio.aws.transfer.model.HomeDirectoryMapEntry.ReadOnly
    ]] =
      AwsError.unwrapOptionField("homeDirectoryMappings", homeDirectoryMappings)
    def getHomeDirectoryType
        : ZIO[Any, AwsError, zio.aws.transfer.model.HomeDirectoryType] =
      AwsError.unwrapOptionField("homeDirectoryType", homeDirectoryType)
    def getPolicy: ZIO[Any, AwsError, Policy] =
      AwsError.unwrapOptionField("policy", policy)
    def getPosixProfile
        : ZIO[Any, AwsError, zio.aws.transfer.model.PosixProfile.ReadOnly] =
      AwsError.unwrapOptionField("posixProfile", posixProfile)
    def getRole: ZIO[Any, AwsError, Role] =
      AwsError.unwrapOptionField("role", role)
    def getExternalId: ZIO[Any, AwsError, ExternalId] =
      AwsError.unwrapOptionField("externalId", externalId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.DescribedAccess
  ) extends zio.aws.transfer.model.DescribedAccess.ReadOnly {
    override val homeDirectory: Optional[HomeDirectory] = zio.aws.core.internal
      .optionalFromNullable(impl.homeDirectory())
      .map(value => zio.aws.transfer.model.primitives.HomeDirectory(value))
    override val homeDirectoryMappings: Optional[
      List[zio.aws.transfer.model.HomeDirectoryMapEntry.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.homeDirectoryMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transfer.model.HomeDirectoryMapEntry.wrap(item)
        }.toList
      )
    override val homeDirectoryType
        : Optional[zio.aws.transfer.model.HomeDirectoryType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.homeDirectoryType())
        .map(value => zio.aws.transfer.model.HomeDirectoryType.wrap(value))
    override val policy: Optional[Policy] = zio.aws.core.internal
      .optionalFromNullable(impl.policy())
      .map(value => zio.aws.transfer.model.primitives.Policy(value))
    override val posixProfile
        : Optional[zio.aws.transfer.model.PosixProfile.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.posixProfile())
        .map(value => zio.aws.transfer.model.PosixProfile.wrap(value))
    override val role: Optional[Role] = zio.aws.core.internal
      .optionalFromNullable(impl.role())
      .map(value => zio.aws.transfer.model.primitives.Role(value))
    override val externalId: Optional[ExternalId] = zio.aws.core.internal
      .optionalFromNullable(impl.externalId())
      .map(value => zio.aws.transfer.model.primitives.ExternalId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.DescribedAccess
  ): zio.aws.transfer.model.DescribedAccess.ReadOnly = new Wrapper(impl)
}
