package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{
  SecurityPolicyOption,
  SecurityPolicyName,
  Fips
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribedSecurityPolicy(
    fips: Optional[Fips] = Optional.Absent,
    securityPolicyName: SecurityPolicyName,
    sshCiphers: Optional[Iterable[SecurityPolicyOption]] = Optional.Absent,
    sshKexs: Optional[Iterable[SecurityPolicyOption]] = Optional.Absent,
    sshMacs: Optional[Iterable[SecurityPolicyOption]] = Optional.Absent,
    tlsCiphers: Optional[Iterable[SecurityPolicyOption]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.DescribedSecurityPolicy = {
    import DescribedSecurityPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.DescribedSecurityPolicy
      .builder()
      .optionallyWith(fips.map(value => Fips.unwrap(value): java.lang.Boolean))(
        _.fips
      )
      .securityPolicyName(
        SecurityPolicyName.unwrap(securityPolicyName): java.lang.String
      )
      .optionallyWith(
        sshCiphers.map(value =>
          value.map { item =>
            SecurityPolicyOption.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.sshCiphers)
      .optionallyWith(
        sshKexs.map(value =>
          value.map { item =>
            SecurityPolicyOption.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.sshKexs)
      .optionallyWith(
        sshMacs.map(value =>
          value.map { item =>
            SecurityPolicyOption.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.sshMacs)
      .optionallyWith(
        tlsCiphers.map(value =>
          value.map { item =>
            SecurityPolicyOption.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.tlsCiphers)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.DescribedSecurityPolicy.ReadOnly =
    zio.aws.transfer.model.DescribedSecurityPolicy.wrap(buildAwsValue())
}
object DescribedSecurityPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.DescribedSecurityPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.DescribedSecurityPolicy =
      zio.aws.transfer.model.DescribedSecurityPolicy(
        fips.map(value => value),
        securityPolicyName,
        sshCiphers.map(value => value),
        sshKexs.map(value => value),
        sshMacs.map(value => value),
        tlsCiphers.map(value => value)
      )
    def fips: Optional[Fips]
    def securityPolicyName: SecurityPolicyName
    def sshCiphers: Optional[List[SecurityPolicyOption]]
    def sshKexs: Optional[List[SecurityPolicyOption]]
    def sshMacs: Optional[List[SecurityPolicyOption]]
    def tlsCiphers: Optional[List[SecurityPolicyOption]]
    def getFips: ZIO[Any, AwsError, Fips] =
      AwsError.unwrapOptionField("fips", fips)
    def getSecurityPolicyName: ZIO[Any, Nothing, SecurityPolicyName] =
      ZIO.succeed(securityPolicyName)
    def getSshCiphers: ZIO[Any, AwsError, List[SecurityPolicyOption]] =
      AwsError.unwrapOptionField("sshCiphers", sshCiphers)
    def getSshKexs: ZIO[Any, AwsError, List[SecurityPolicyOption]] =
      AwsError.unwrapOptionField("sshKexs", sshKexs)
    def getSshMacs: ZIO[Any, AwsError, List[SecurityPolicyOption]] =
      AwsError.unwrapOptionField("sshMacs", sshMacs)
    def getTlsCiphers: ZIO[Any, AwsError, List[SecurityPolicyOption]] =
      AwsError.unwrapOptionField("tlsCiphers", tlsCiphers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.DescribedSecurityPolicy
  ) extends zio.aws.transfer.model.DescribedSecurityPolicy.ReadOnly {
    override val fips: Optional[Fips] = zio.aws.core.internal
      .optionalFromNullable(impl.fips())
      .map(value => zio.aws.transfer.model.primitives.Fips(value))
    override val securityPolicyName: SecurityPolicyName =
      zio.aws.transfer.model.primitives
        .SecurityPolicyName(impl.securityPolicyName())
    override val sshCiphers: Optional[List[SecurityPolicyOption]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sshCiphers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transfer.model.primitives.SecurityPolicyOption(item)
          }.toList
        )
    override val sshKexs: Optional[List[SecurityPolicyOption]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sshKexs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transfer.model.primitives.SecurityPolicyOption(item)
          }.toList
        )
    override val sshMacs: Optional[List[SecurityPolicyOption]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sshMacs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transfer.model.primitives.SecurityPolicyOption(item)
          }.toList
        )
    override val tlsCiphers: Optional[List[SecurityPolicyOption]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tlsCiphers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transfer.model.primitives.SecurityPolicyOption(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.DescribedSecurityPolicy
  ): zio.aws.transfer.model.DescribedSecurityPolicy.ReadOnly = new Wrapper(impl)
}
