package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{EfsPath, EfsFileSystemId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EfsFileLocation(
    fileSystemId: Optional[EfsFileSystemId] = Optional.Absent,
    path: Optional[EfsPath] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.EfsFileLocation = {
    import EfsFileLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.EfsFileLocation
      .builder()
      .optionallyWith(
        fileSystemId.map(value =>
          EfsFileSystemId.unwrap(value): java.lang.String
        )
      )(_.fileSystemId)
      .optionallyWith(
        path.map(value => EfsPath.unwrap(value): java.lang.String)
      )(_.path)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.EfsFileLocation.ReadOnly =
    zio.aws.transfer.model.EfsFileLocation.wrap(buildAwsValue())
}
object EfsFileLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.EfsFileLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.EfsFileLocation =
      zio.aws.transfer.model.EfsFileLocation(
        fileSystemId.map(value => value),
        path.map(value => value)
      )
    def fileSystemId: Optional[EfsFileSystemId]
    def path: Optional[EfsPath]
    def getFileSystemId: ZIO[Any, AwsError, EfsFileSystemId] =
      AwsError.unwrapOptionField("fileSystemId", fileSystemId)
    def getPath: ZIO[Any, AwsError, EfsPath] =
      AwsError.unwrapOptionField("path", path)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.EfsFileLocation
  ) extends zio.aws.transfer.model.EfsFileLocation.ReadOnly {
    override val fileSystemId: Optional[EfsFileSystemId] = zio.aws.core.internal
      .optionalFromNullable(impl.fileSystemId())
      .map(value => zio.aws.transfer.model.primitives.EfsFileSystemId(value))
    override val path: Optional[EfsPath] = zio.aws.core.internal
      .optionalFromNullable(impl.path())
      .map(value => zio.aws.transfer.model.primitives.EfsPath(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.EfsFileLocation
  ): zio.aws.transfer.model.EfsFileLocation.ReadOnly = new Wrapper(impl)
}
