package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.PassiveIp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ProtocolDetails(
    passiveIp: Optional[PassiveIp] = Optional.Absent,
    tlsSessionResumptionMode: Optional[
      zio.aws.transfer.model.TlsSessionResumptionMode
    ] = Optional.Absent,
    setStatOption: Optional[zio.aws.transfer.model.SetStatOption] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.ProtocolDetails = {
    import ProtocolDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.ProtocolDetails
      .builder()
      .optionallyWith(
        passiveIp.map(value => PassiveIp.unwrap(value): java.lang.String)
      )(_.passiveIp)
      .optionallyWith(tlsSessionResumptionMode.map(value => value.unwrap))(
        _.tlsSessionResumptionMode
      )
      .optionallyWith(setStatOption.map(value => value.unwrap))(_.setStatOption)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.ProtocolDetails.ReadOnly =
    zio.aws.transfer.model.ProtocolDetails.wrap(buildAwsValue())
}
object ProtocolDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.ProtocolDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.ProtocolDetails =
      zio.aws.transfer.model.ProtocolDetails(
        passiveIp.map(value => value),
        tlsSessionResumptionMode.map(value => value),
        setStatOption.map(value => value)
      )
    def passiveIp: Optional[PassiveIp]
    def tlsSessionResumptionMode
        : Optional[zio.aws.transfer.model.TlsSessionResumptionMode]
    def setStatOption: Optional[zio.aws.transfer.model.SetStatOption]
    def getPassiveIp: ZIO[Any, AwsError, PassiveIp] =
      AwsError.unwrapOptionField("passiveIp", passiveIp)
    def getTlsSessionResumptionMode
        : ZIO[Any, AwsError, zio.aws.transfer.model.TlsSessionResumptionMode] =
      AwsError.unwrapOptionField(
        "tlsSessionResumptionMode",
        tlsSessionResumptionMode
      )
    def getSetStatOption
        : ZIO[Any, AwsError, zio.aws.transfer.model.SetStatOption] =
      AwsError.unwrapOptionField("setStatOption", setStatOption)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.ProtocolDetails
  ) extends zio.aws.transfer.model.ProtocolDetails.ReadOnly {
    override val passiveIp: Optional[PassiveIp] = zio.aws.core.internal
      .optionalFromNullable(impl.passiveIp())
      .map(value => zio.aws.transfer.model.primitives.PassiveIp(value))
    override val tlsSessionResumptionMode
        : Optional[zio.aws.transfer.model.TlsSessionResumptionMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tlsSessionResumptionMode())
        .map(value =>
          zio.aws.transfer.model.TlsSessionResumptionMode.wrap(value)
        )
    override val setStatOption: Optional[zio.aws.transfer.model.SetStatOption] =
      zio.aws.core.internal
        .optionalFromNullable(impl.setStatOption())
        .map(value => zio.aws.transfer.model.SetStatOption.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.ProtocolDetails
  ): zio.aws.transfer.model.ProtocolDetails.ReadOnly = new Wrapper(impl)
}
